/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.GetPublicKeyRequest;
import com.aliyun.dkms.gcs.sdk.models.GetPublicKeyResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyun.tea.utils.StringUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetPublicKeyTransferHandler
implements KmsTransferHandler<GetPublicKeyRequest, GetPublicKeyResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public GetPublicKeyTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public GetPublicKeyRequest buildDKMSRequest(AcsRequest request, RuntimeOptions runtimeOptions) {
        com.aliyuncs.kms.model.v20160120.GetPublicKeyRequest getPublicKeyKmsRequest = (com.aliyuncs.kms.model.v20160120.GetPublicKeyRequest)request;
        GetPublicKeyRequest getPublicKeyDKmsRequest = new GetPublicKeyRequest();
        getPublicKeyDKmsRequest.setKeyId(getPublicKeyKmsRequest.getKeyId());
        final String keyVersionId = getPublicKeyKmsRequest.getKeyVersionId();
        if (!StringUtils.isEmpty((CharSequence)keyVersionId)) {
            getPublicKeyDKmsRequest.setRequestHeaders((Map)new HashMap<String, String>(){
                {
                    this.put("x-kms-migrationkeyversionid", keyVersionId);
                }
            });
        }
        return getPublicKeyDKmsRequest;
    }

    @Override
    public GetPublicKeyResponse callDKMS(GetPublicKeyRequest dkmsRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        return this.client.getPublicKeyWithOptions(dkmsRequest, runtimeOptions);
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, GetPublicKeyResponse response) throws ClientException {
        Map responseHeaders = response.getResponseHeaders();
        String keyVersionId = null;
        if (responseHeaders != null) {
            keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid");
        }
        com.aliyuncs.kms.model.v20160120.GetPublicKeyResponse getPublicKeyKmsResponse = new com.aliyuncs.kms.model.v20160120.GetPublicKeyResponse();
        getPublicKeyKmsResponse.setKeyId(response.getKeyId());
        getPublicKeyKmsResponse.setKeyVersionId(keyVersionId);
        getPublicKeyKmsResponse.setRequestId(response.getRequestId());
        getPublicKeyKmsResponse.setPublicKey(response.getPublicKey());
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)getPublicKeyKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

