/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.util;

import com.aliyun.datahub.shaded.org.apache.commons.lang3.StringUtils;

public abstract class FormatUtils {
    public static boolean checkProjectName(String projectName, boolean create) {
        return FormatUtils.isNameValid(projectName, 3, 32, create);
    }

    public static boolean checkProjectName(String projectName) {
        return FormatUtils.checkProjectName(projectName, false);
    }

    public static boolean checkTopicName(String topicName, boolean create) {
        return FormatUtils.isNameValid(topicName, 1, 128, create);
    }

    public static boolean checkTopicName(String topicName) {
        return FormatUtils.checkTopicName(topicName, false);
    }

    public static boolean checkComment(String comment) {
        return comment != null && comment.length() <= 1024;
    }

    public static boolean checkShardId(String shardId) {
        return StringUtils.isNumeric(shardId);
    }

    private static boolean isNameValid(String name, int minLen, int maxLen, boolean create) {
        if (name == null || name.length() < minLen || name.length() > maxLen) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!(i == 0 ? !Character.isAlphabetic(c) && create : !Character.isAlphabetic(c) && !Character.isDigit(c) && c != '_')) continue;
            return false;
        }
        return true;
    }

    public static boolean checkDay(String day) {
        return day != null && !day.isEmpty() && day.length() == 8;
    }
}

