/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.model;

import com.aliyun.datahub.client.model.BaseResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.List;

@JsonDeserialize(converter=Converter.class)
public class GetRecordsResult
extends BaseResult {
    @JsonProperty(value="NextCursor")
    private String nextCursor;
    @JsonProperty(value="RecordCount")
    private int recordCount;
    @JsonProperty(value="StartSeq")
    private long startSequence;
    @JsonProperty(value="LatestSeq")
    private long latestSequence = -1L;
    @JsonProperty(value="LatestTime")
    private long latestTime = -1L;
    @JsonProperty(value="Records")
    protected List<RecordEntry> records;

    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public long getStartSequence() {
        return this.startSequence;
    }

    public void setStartSequence(long startSequence) {
        this.startSequence = startSequence;
    }

    public long getLatestSequence() {
        return this.latestSequence;
    }

    public void setLatestSequence(long latestSequence) {
        this.latestSequence = latestSequence;
    }

    public long getLatestTime() {
        return this.latestTime;
    }

    public void setLatestTime(long latestTime) {
        this.latestTime = latestTime;
    }

    public List<RecordEntry> getRecords() {
        return this.records;
    }

    public void setRecords(List<RecordEntry> records) {
        this.records = records;
    }

    static class Converter
    extends StdConverter<GetRecordsResult, GetRecordsResult> {
        Converter() {
        }

        public GetRecordsResult convert(GetRecordsResult getRecordsResult) {
            for (RecordEntry recordEntry : getRecordsResult.getRecords()) {
                recordEntry.setLatestSequence(getRecordsResult.latestSequence);
                recordEntry.setLatestTime(getRecordsResult.latestTime);
            }
            return getRecordsResult;
        }
    }
}

