/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.impl.DatahubClientJsonImpl;
import com.aliyun.datahub.client.impl.request.protobuf.GetBatchRecordsRequestPB;
import com.aliyun.datahub.client.impl.request.protobuf.PutBatchRecordsRequestPB;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.PutRecordsByShardResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.protobuf.GetBatchRecordsResultPB;
import com.aliyun.datahub.client.util.FormatUtils;
import com.aliyun.datahub.shaded.org.apache.commons.lang3.StringUtils;
import com.codahale.metrics.Timer;
import java.util.List;

public class DatahubClientBatchImpl
extends DatahubClientJsonImpl {
    public DatahubClientBatchImpl(String endpoint, Account account, HttpConfig httpConfig, String userAgent) {
        super(endpoint, account, httpConfig, userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordsByShardResult putRecordsByShard(String projectName, String topicName, String shardId, List<RecordEntry> records) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        if (records == null || records.isEmpty()) {
            throw new InvalidParameterException("Records is null or empty");
        }
        PutBatchRecordsRequestPB request = new PutBatchRecordsRequestPB(this.httpConfig.getCompressType()).setRecords(records);
        Timer.Context context = this.PUT_LATENCY_TIMER == null ? null : this.PUT_LATENCY_TIMER.time();
        try {
            PutRecordsByShardResult result = this.callWrapper(this.getService().putBatchRecordsByShard(projectName, topicName, shardId, request));
            if (result != null) {
                if (this.PUT_QPS_METER != null) {
                    this.PUT_QPS_METER.mark(1L);
                }
                if (this.PUT_RPS_METER != null) {
                    this.PUT_RPS_METER.mark((long)records.size());
                }
            }
            PutRecordsByShardResult putRecordsByShardResult = result;
            return putRecordsByShardResult;
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    @Override
    public GetRecordsResult getRecords(String projectName, String topicName, String shardId, String cursor, int limit) {
        return this.getRecords(projectName, topicName, shardId, null, cursor, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecordsResult getRecords(String projectName, String topicName, String shardId, RecordSchema schema, String cursor, int limit) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty(cursor)) {
            throw new InvalidParameterException("Cursor format is invalid");
        }
        limit = Math.max(1, limit);
        limit = Math.min(1000, limit);
        GetBatchRecordsRequestPB request = new GetBatchRecordsRequestPB();
        request.setCursor(cursor).setLimit(limit);
        Timer.Context context = this.GET_LATENCY_TIMER == null ? null : this.GET_LATENCY_TIMER.time();
        try {
            GetBatchRecordsResultPB result = this.callWrapper(this.getService().getBatchRecords(projectName, topicName, shardId, request));
            if (result != null) {
                result.internalSetSchema(schema);
                result.internalSetShardId(shardId);
                if (this.GET_QPS_METER != null) {
                    this.GET_QPS_METER.mark(1L);
                }
                if (this.GET_RPS_METER != null) {
                    this.GET_RPS_METER.mark((long)result.getRecordCount());
                }
            }
            GetBatchRecordsResultPB getBatchRecordsResultPB = result;
            return getBatchRecordsResultPB;
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }
}

