/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.logging;

import com.aliyun.core.logging.DefaultLogger;
import com.aliyun.core.logging.LogLevel;
import com.aliyun.core.utils.StringUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class ClientLogger {
    private static final Pattern CRLF_PATTERN = Pattern.compile("[\r\n]");
    private final Logger logger;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        Logger initLogger = LoggerFactory.getLogger((String)className);
        this.logger = initLogger instanceof NOPLogger ? new DefaultLogger(className) : initLogger;
    }

    public void verbose(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(ClientLogger.sanitizeLogMessageInput(message));
        }
    }

    public void verbose(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.performLogging(LogLevel.VERBOSE, false, format, args);
        }
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(ClientLogger.sanitizeLogMessageInput(message));
        }
    }

    public void info(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.performLogging(LogLevel.INFORMATIONAL, false, format, args);
        }
    }

    public void warning(String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(ClientLogger.sanitizeLogMessageInput(message));
        }
    }

    public void warning(String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.performLogging(LogLevel.WARNING, false, format, args);
        }
    }

    public void error(String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ClientLogger.sanitizeLogMessageInput(message));
        }
    }

    public void error(String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.performLogging(LogLevel.ERROR, false, format, args);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsWarning(runtimeException);
    }

    public <T extends Throwable> T logThrowableAsWarning(T throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (!this.logger.isWarnEnabled()) {
            return throwable;
        }
        this.performLogging(LogLevel.WARNING, true, throwable.getMessage(), throwable);
        return throwable;
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsError(runtimeException);
    }

    public <T extends Throwable> T logThrowableAsError(T throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (!this.logger.isErrorEnabled()) {
            return throwable;
        }
        this.performLogging(LogLevel.ERROR, true, throwable.getMessage(), throwable);
        return throwable;
    }

    private void performLogging(LogLevel logLevel, boolean isExceptionLogging, String format, Object ... args) {
        String throwableMessage = "";
        if (this.doesArgsHaveThrowable(args)) {
            Object throwable;
            if (!isExceptionLogging && (throwable = args[args.length - 1]) instanceof Throwable) {
                throwableMessage = ((Throwable)throwable).getMessage();
            }
            if (!this.logger.isDebugEnabled()) {
                args = this.removeThrowable(args);
            }
        }
        ClientLogger.sanitizeLogMessageInput(format);
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(format, args);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(format, args);
                break;
            }
            case WARNING: {
                if (!StringUtils.isEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.warn(format, args);
                break;
            }
            case ERROR: {
                if (!StringUtils.isEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.error(format, args);
                break;
            }
        }
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        if (logLevel == null) {
            return false;
        }
        switch (logLevel) {
            case VERBOSE: {
                return this.logger.isDebugEnabled();
            }
            case INFORMATIONAL: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private boolean doesArgsHaveThrowable(Object ... args) {
        if (args.length == 0) {
            return false;
        }
        return args[args.length - 1] instanceof Throwable;
    }

    private Object[] removeThrowable(Object ... args) {
        return Arrays.copyOf(args, args.length - 1);
    }

    private static String sanitizeLogMessageInput(String logMessage) {
        if (StringUtils.isEmpty(logMessage)) {
            return logMessage;
        }
        return CRLF_PATTERN.matcher(logMessage).replaceAll("");
    }
}

