/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.CompatibleUrlConnClient;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.MethodType;
import com.aliyun.auth.credentials.provider.HttpCredentialProvider;
import com.aliyun.auth.credentials.utils.AuthUtils;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.auth.credentials.utils.RefreshResult;
import com.aliyun.core.utils.StringUtils;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Map;

public class URLCredentialProvider
extends HttpCredentialProvider {
    private final URL credentialsURI;
    private int connectTimeout;
    private int readTimeout;
    private final CompatibleUrlConnClient client;

    private URLCredentialProvider(BuilderImpl builder) {
        super(builder);
        String credentialsURI;
        String string = credentialsURI = builder.credentialsURI == null ? AuthUtils.getEnvironmentCredentialsURI() : builder.credentialsURI;
        if (StringUtils.isEmpty((CharSequence)credentialsURI)) {
            throw new IllegalArgumentException("Credential URI or environment variable ALIBABA_CLOUD_CREDENTIALS_URI cannot be empty.");
        }
        try {
            this.credentialsURI = new URL(credentialsURI);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Credential URI is not valid.");
        }
        this.connectTimeout = builder.connectionTimeout == null ? 5000 : builder.connectionTimeout;
        this.readTimeout = builder.readTimeout == null ? 10000 : builder.readTimeout;
        this.client = new CompatibleUrlConnClient();
        this.buildRefreshCache();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<ICredential> refreshCredentials() {
        Map map;
        HttpResponse response;
        HttpRequest request = new HttpRequest(this.credentialsURI.toString());
        request.setSysMethod(MethodType.GET);
        request.setSysConnectTimeout(this.connectTimeout);
        request.setSysReadTimeout(this.readTimeout);
        try {
            response = this.client.syncInvoke(request);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect Server: " + e.toString(), e);
        }
        finally {
            this.client.close();
        }
        if (response.getResponseCode() >= 300 || response.getResponseCode() < 200) {
            throw new CredentialException("Failed to get credentials from server: " + this.credentialsURI.toString() + "\nHttpCode=" + response.getResponseCode() + "\nHttpRAWContent=" + response.getHttpContentString());
        }
        Gson gson = new Gson();
        try {
            map = (Map)gson.fromJson(response.getHttpContentString(), Map.class);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to get credentials from server: " + this.credentialsURI.toString() + "\nHttpCode=" + response.getResponseCode() + "\nHttpRAWContent=" + response.getHttpContentString(), e);
        }
        if (map.containsKey("Code") && ((String)map.get("Code")).equals("Success")) {
            Instant expiration = ParameterHelper.getUTCDate((String)map.get("Expiration")).toInstant();
            Credential credential = Credential.builder().accessKeyId((String)map.get("AccessKeyId")).accessKeySecret((String)map.get("AccessKeySecret")).securityToken((String)map.get("SecurityToken")).build();
            return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
        }
        throw new CredentialException(String.format("Error retrieving credentials from credentialsURI result: %s.", response.getHttpContentString()));
    }

    @Override
    public void close() {
        super.close();
        this.client.close();
    }

    private static final class BuilderImpl
    extends HttpCredentialProvider.BuilderImpl<URLCredentialProvider, Builder>
    implements Builder {
        private String credentialsURI;
        private Integer connectionTimeout;
        private Integer readTimeout;

        private BuilderImpl() {
        }

        @Override
        public Builder credentialsURI(URL credentialsURI) {
            this.credentialsURI = credentialsURI.toString();
            return this;
        }

        @Override
        public Builder credentialsURI(String credentialsURI) {
            this.credentialsURI = credentialsURI;
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public URLCredentialProvider build() {
            return new URLCredentialProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialProvider.Builder<URLCredentialProvider, Builder> {
        public Builder credentialsURI(URL var1);

        public Builder credentialsURI(String var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        @Override
        public URLCredentialProvider build();
    }
}

