package com.aliyun.auth.credentials.utils;

import java.time.Instant;

public final class RefreshResult<T> {
    private final T value;
    private final Instant staleTime;
    private final Instant prefetchTime;

    private RefreshResult(Builder<T> builder) {
        this.value = builder.value;
        this.staleTime = builder.staleTime;
        this.prefetchTime = builder.prefetchTime;
    }

    public static <T> Builder<T> builder(T value) {
        return new Builder<>(value);
    }

    public T value() {
        return value;
    }

    public Instant staleTime() {
        return staleTime;
    }

    public Instant prefetchTime() {
        return prefetchTime;
    }

    public static final class Builder<T> {
        private final T value;
        private Instant staleTime = Instant.MAX;
        private Instant prefetchTime = Instant.MAX;

        private Builder(T value) {
            this.value = value;
        }

        public Builder<T> staleTime(Instant staleTime) {
            this.staleTime = staleTime;
            return this;
        }

        public Builder<T> prefetchTime(Instant prefetchTime) {
            this.prefetchTime = prefetchTime;
            return this;
        }

        public RefreshResult<T> build() {
            return new RefreshResult<>(this);
        }
    }
}
