/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.models;

import com.aliyun.core.annotation.Validation;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.utils.CommonUtil;
import java.io.InputStream;
import java.util.Objects;

public class CommonRequest
extends Request {
    @Validation(required=true)
    private String product;
    @Validation(required=true)
    private String version;
    @Validation(required=true)
    private String action;
    @Validation(required=true)
    private String path;
    @Validation(required=true)
    private HttpMethod httpMethod;
    @Validation(required=true)
    private String requestBodyType;
    @Validation(required=true)
    private String responseBodyType;
    @Validation(required=true)
    private Boolean isFormData;

    private CommonRequest(Builder builder) {
        super(builder);
        this.product = builder.product;
        this.version = builder.version;
        this.action = builder.action;
        this.path = builder.path;
        this.httpMethod = builder.httpMethod;
        this.requestBodyType = builder.requestBodyType;
        this.responseBodyType = builder.responseBodyType;
        this.isFormData = builder.isFormData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CommonRequest create() {
        return CommonRequest.builder().build();
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAction() {
        return this.action;
    }

    public String getPath() {
        return this.path;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getRequestBodyType() {
        return this.requestBodyType;
    }

    public String getResponseBodyType() {
        return this.responseBodyType;
    }

    public Boolean isFormData() {
        return this.isFormData;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends Request.Builder<CommonRequest, Builder> {
        private String product;
        private String version;
        private String action;
        private String path = "/";
        private HttpMethod httpMethod = HttpMethod.GET;
        private String requestBodyType = "json";
        private String responseBodyType = "json";
        private Boolean isFormData = false;

        private Builder() {
        }

        private Builder(CommonRequest request) {
            super(request);
        }

        public Builder putQueryParameters(String name, Object value) {
            if (!CommonUtil.isUnset((Object)name)) {
                this.putQueryParameter(name, value);
            }
            return this;
        }

        public Builder putBodyParameters(String name, Object value) {
            if (!CommonUtil.isUnset((Object)name)) {
                this.putBodyParameter(name, value);
            }
            return this;
        }

        public Builder putBodyStream(InputStream value) {
            if (Objects.nonNull(value)) {
                this.putBodyParameter("body", value);
            }
            return this;
        }

        public Builder putHeaderParameters(String name, Object value) {
            if (!CommonUtil.isUnset((Object)name)) {
                this.putHeaderParameter(name, value);
            }
            return this;
        }

        public Builder product(String product) {
            this.product = product;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder requestBodyType(String requestBodyType) {
            this.requestBodyType = requestBodyType;
            return this;
        }

        public Builder responseBodyType(String responseBodyType) {
            this.responseBodyType = responseBodyType;
            return this;
        }

        public Builder isFormData(boolean isFormData) {
            this.isFormData = isFormData;
            return this;
        }

        public CommonRequest build() {
            return new CommonRequest(this);
        }
    }
}

