/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.httpRequest;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.provider.AnonymousCredentialProvider;
import com.aliyun.auth.signature.SignerParams;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.MapUtils;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.pop.auth.RpcSignatureComposer;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import darabonba.core.RequestStyle;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaPair;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.utils.CommonUtil;
import darabonba.core.utils.ModelUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RpcHttpReqInterceptor
implements HttpRequestInterceptor {
    private final ClientLogger logger = new ClientLogger(RpcHttpReqInterceptor.class);

    public HttpRequest modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        HttpRequest httpRequest = context.httpRequest();
        if (!request.style().equals((Object)RequestStyle.RPC)) {
            return httpRequest;
        }
        TeaConfiguration configuration = context.configuration();
        ClientConfiguration clientConfiguration = configuration.clientConfiguration();
        PopSigner signer = (PopSigner)clientConfiguration.option(ClientOption.SIGNER);
        if (signer.getSignerVersion() != SignatureVersion.V1) {
            return httpRequest;
        }
        HttpMethod method = Optional.ofNullable(configuration.method()).orElseGet(() -> ((TeaRequest)request).method());
        Map query = CommonUtil.merge(String.class, (Object[])new Object[]{CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("Timestamp", (Object)CommonUtil.getTimestamp()), new TeaPair("SignatureNonce", (Object)CommonUtil.getNonce())}), request.query()});
        HashMap<String, String> headers = new HashMap<String, String>(request.headers().toMap());
        Map body = new HashMap();
        if (!CommonUtil.isUnset((Object)request.body())) {
            body = ModelUtil.query((Map)CommonUtil.assertAsMap((Object)request.body()));
            headers.put("content-type", "application/x-www-form-urlencoded");
        }
        Map paramsToSign = MapUtils.concat((Map)query, body);
        if (!(configuration.credentialProvider() instanceof AnonymousCredentialProvider)) {
            ICredential credential = configuration.credentialProvider().getCredentials();
            String securityToken = credential.securityToken();
            if (!StringUtils.isEmpty((CharSequence)securityToken)) {
                query.put("SecurityToken", securityToken);
            }
            query.putAll(CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("SignatureMethod", (Object)signer.getSignerName()), new TeaPair("SignatureVersion", (Object)"1.0"), new TeaPair("AccessKeyId", (Object)credential.accessKeyId())}));
            paramsToSign.putAll(query);
            String strToSign = RpcSignatureComposer.composeStringToSign(method, paramsToSign, headers, request.pathname());
            this.logger.verbose("The string to sign is: {}", new Object[]{strToSign});
            SignerParams params = SignerParams.create();
            Credential newCredential = Credential.builder().accessKeyId(credential.accessKeyId()).securityToken(securityToken).accessKeySecret(Optional.ofNullable(credential.accessKeySecret()).orElse("") + "&").build();
            params.setCredentials((ICredential)newCredential);
            String signature = signer.signString(strToSign, params);
            query.put("Signature", signature);
            this.logger.verbose("Signature value is: {}", new Object[]{signature});
        }
        HttpHeaders httpHeaders = new HttpHeaders(headers);
        httpRequest = new HttpRequest(method, ModelUtil.composeUrl((String)configuration.endpoint(), (Map)query, (String)configuration.protocol(), (String)request.pathname()));
        httpRequest.setHeaders(httpHeaders);
        if (!body.isEmpty()) {
            httpRequest.setBody(StringUtils.toBytes((String)Objects.requireNonNull(ModelUtil.toFormString(body))));
        }
        return httpRequest;
    }
}

