/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.clients;

import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.core.utils.SdkAutoCloseable;
import com.aliyun.sdk.gateway.pop.Configuration;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.clients.CommonAsyncClientBuilder;
import com.aliyun.sdk.gateway.pop.models.CommonRequest;
import com.aliyun.sdk.gateway.pop.models.CommonResponse;
import com.aliyun.sdk.gateway.pop.sse.ResponseBodyIterator;
import darabonba.core.RequestModel;
import darabonba.core.RequestStyle;
import darabonba.core.ResponseIterable;
import darabonba.core.ResponseIterator;
import darabonba.core.TeaAsyncHandler;
import darabonba.core.TeaModel;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientExecutionParams;
import darabonba.core.sse.SSEHttpResponseHandler;
import darabonba.core.sse.SSEResponseIterator;
import java.util.concurrent.CompletableFuture;

public final class CommonAsyncClient
implements SdkAutoCloseable {
    private final TeaAsyncHandler handler;

    CommonAsyncClient(ClientConfiguration configuration) {
        this.handler = new TeaAsyncHandler(configuration);
    }

    public static CommonAsyncClientBuilder builder() {
        return (CommonAsyncClientBuilder)((Object)new CommonAsyncClientBuilder().serviceConfiguration(Configuration.create().setSignatureVersion(SignatureVersion.V3)));
    }

    static CommonAsyncClient create() {
        return (CommonAsyncClient)CommonAsyncClient.builder().build();
    }

    public void close() {
        this.handler.close();
    }

    public ResponseIterable<String> callSseApi(CommonRequest request) {
        this.handler.validateRequestModel((RequestModel)request);
        TeaRequest teaRequest = TeaRequest.create().setProduct(request.getProduct()).setVersion(request.getVersion()).setStyle(RequestStyle.SSE).setAction(request.getAction()).setMethod(request.getHttpMethod()).setPathRegex(request.getPath()).setReqBodyType(request.getRequestBodyType()).setBodyType(request.getResponseBodyType()).setBodyIsForm(request.isFormData()).formModel((RequestModel)request);
        ResponseBodyIterator iterator = ResponseBodyIterator.create();
        ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withHttpResponseHandler((HttpResponseHandler)new SSEHttpResponseHandler((SSEResponseIterator)iterator));
        this.handler.execute(params);
        return new ResponseIterable((ResponseIterator)iterator);
    }

    public CompletableFuture<CommonResponse> callApi(CommonRequest request) {
        try {
            this.handler.validateRequestModel((RequestModel)request);
            TeaRequest teaRequest = TeaRequest.create().setProduct(request.getProduct()).setVersion(request.getVersion()).setStyle(request.getPath().equals("/") ? RequestStyle.RPC : RequestStyle.RESTFUL).setAction(request.getAction()).setMethod(request.getHttpMethod()).setPathRegex(request.getPath()).setReqBodyType(request.getRequestBodyType()).setBodyType(request.getResponseBodyType()).setBodyIsForm(request.isFormData()).formModel((RequestModel)request);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)CommonResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<CommonResponse> future = new CompletableFuture<CommonResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }
}

