package com.aliyun.sdk.gateway.pop.models;

import darabonba.core.TeaModel;

public abstract class Response extends TeaModel {

    protected Response(BuilderImpl<?, ?> builder) {
    }

    public abstract Builder toBuilder();

    public interface Builder<ProviderT extends Response, BuilderT extends Response.Builder> {

        ProviderT build();

    }

    protected abstract static class BuilderImpl<ProviderT extends Response, BuilderT extends Response.Builder>
            implements Builder<ProviderT, BuilderT> {

        protected BuilderImpl() {
        }

        protected BuilderImpl(Response response) {
        }

    }

}
