package com.aliyun.sdk.gateway.pop.interceptor.response;

import com.aliyun.core.http.BodyType;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.ParseUtil;
import com.aliyun.sdk.gateway.pop.exception.PopServerException;
import darabonba.core.TeaResponse;
import darabonba.core.exception.TeaException;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.utils.CommonUtil;

public class PopResInterceptor implements ResponseInterceptor {
    private final ClientLogger logger = new ClientLogger(PopResInterceptor.class);

    @Override
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        logger.info("TeaResponse process begin.");
        TeaResponse teaResponse = context.teaResponse();
        if (teaResponse.success()) {
            HttpResponse httpResponse = teaResponse.httpResponse();
            Object response;
            try {
                switch (context.teaRequest().bodyType()) {
                    case BodyType.BYTE:
                        //response = CommonUtil.buildMap(
                        //        new TeaPair("body", httpResponse.getBodyAsByteArray()),
                        //        new TeaPair("headers", headers)
                        //);
                        response = httpResponse.getBodyAsByteArray();
                        break;
                    case BodyType.BIN:
                    case BodyType.STRING:
                        //response = CommonUtil.buildMap(
                        //        new TeaPair("body", httpResponse.getBodyAsString()),
                        //        new TeaPair("headers", headers)
                        //);
                        response = httpResponse.getBodyAsString();
                        break;
                    case BodyType.JSON:
                        //response = CommonUtil.buildMap(
                        //        new TeaPair("body", CommonUtil.assertAsMap(ParseUtil.readAsJSON(httpResponse.getBodyAsString()))),
                        //        new TeaPair("headers", headers)
                        //);
                        response = CommonUtil.assertAsMap(ParseUtil.readAsJSON(httpResponse.getBodyAsString()));
                        break;
                    case BodyType.ARRAY:
                        //response = CommonUtil.buildMap(
                        //        new TeaPair("body", CommonUtil.assertAsArray(ParseUtil.readAsJSON(httpResponse.getBodyAsString()))),
                        ///        new TeaPair("headers", headers)
                        //);
                        response = CommonUtil.assertAsArray(ParseUtil.readAsJSON(httpResponse.getBodyAsString()));
                        break;
                    default:
                        //response = CommonUtil.buildMap(
                        //        new TeaPair("body", httpResponse.getBodyAsString()),
                        //        new TeaPair("headers", headers)
                        //);
                        response = httpResponse.getBodyAsString();
                }
                teaResponse.setDeserializedBody(response);
            } catch (Exception e) {
                teaResponse.setException(new TeaException("Process response body error!", e));
            } finally {
                httpResponse.close();
            }
        }
        return teaResponse;
    }
}
