package com.aliyun.sdk.gateway.pop;

import com.aliyun.sdk.gateway.pop.auth.SignatureAlgorithm;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import darabonba.core.ServiceConfiguration;

public final class Configuration implements ServiceConfiguration {
    public static final SignatureVersion DEFAULT_SIGNATURE_VERSION = SignatureVersion.V1;
    public static final SignatureAlgorithm DEFAULT_SIGNATURE_ALGORRITHM_V1 = SignatureAlgorithm.HMAC_SHA1;
    public static final SignatureAlgorithm DEFAULT_SIGNATURE_ALGORRITHM_V3 = SignatureAlgorithm.ACS3_HMAC_SHA256;

    private SignatureVersion signatureVersion = DEFAULT_SIGNATURE_VERSION;
    private SignatureAlgorithm signatureAlgorithmV1 = DEFAULT_SIGNATURE_ALGORRITHM_V1;
    private SignatureAlgorithm signatureAlgorithmV3 = DEFAULT_SIGNATURE_ALGORRITHM_V3;

    private Configuration() {
    }

    public static Configuration create() {
        return new Configuration();
    }

    public SignatureVersion signatureVersion() {
        return signatureVersion;
    }

    public Configuration setSignatureVersion(SignatureVersion signatureVersion) {
        this.signatureVersion = signatureVersion;
        return this;
    }

    public SignatureAlgorithm signatureAlgorithmV1() {
        return signatureAlgorithmV1;
    }

    public Configuration setSignatureAlgorithmV1(SignatureAlgorithm signatureAlgorithmV1) {
        this.signatureAlgorithmV1 = signatureAlgorithmV1;
        return this;
    }

    public SignatureAlgorithm signatureAlgorithmV3() {
        return signatureAlgorithmV3;
    }

    public Configuration setSignatureAlgorithmV3(SignatureAlgorithm signatureAlgorithmV3) {
        this.signatureAlgorithmV3 = signatureAlgorithmV3;
        return this;
    }


}
