/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.utils;

import com.aliyuncs.kms.secretsmanager.client.utils.ConfigUtils;
import com.aliyuncs.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Map;

public class ClientKeyUtils {
    private static final String PKCS12 = "PKCS12";

    private ClientKeyUtils() {
    }

    public static String getPrivateKeyPemFromPk12(byte[] pk12, String password) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(PKCS12);
        keyStore.load(new ByteArrayInputStream(pk12), password.toCharArray());
        Enumeration<String> e = keyStore.aliases();
        String alias = e.nextElement();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static String getPassword(Map envMap, String envVariableName, String filePathName) {
        String passwordFilePath;
        String passwordFromEnvName = "";
        if (!StringUtils.isEmpty((CharSequence)envVariableName)) {
            passwordFromEnvName = envMap.getOrDefault(envVariableName, "");
        }
        String password = "";
        if (!StringUtils.isEmpty((CharSequence)passwordFromEnvName)) {
            password = System.getenv(passwordFromEnvName);
        }
        if (StringUtils.isEmpty((CharSequence)password) && !StringUtils.isEmpty((CharSequence)filePathName) && !StringUtils.isEmpty((CharSequence)(passwordFilePath = envMap.getOrDefault(filePathName, "")))) {
            password = ClientKeyUtils.readPasswordFile(passwordFilePath);
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            password = System.getenv("client_key_password");
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("client key password is not provided");
        }
        return password;
    }

    public static String readPasswordFile(String passwordFilePath) {
        return ConfigUtils.readFileContent(passwordFilePath);
    }
}

