/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryDeviceStatRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="DeviceType")
    private String deviceType;
    @Query
    @NameInMap(value="EndTime")
    @Validation(required=true)
    private String endTime;
    @Query
    @NameInMap(value="QueryType")
    @Validation(required=true)
    private String queryType;
    @Query
    @NameInMap(value="StartTime")
    @Validation(required=true)
    private String startTime;

    private QueryDeviceStatRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.deviceType = builder.deviceType;
        this.endTime = builder.endTime;
        this.queryType = builder.queryType;
        this.startTime = builder.startTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryDeviceStatRequest create() {
        return QueryDeviceStatRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public static final class Builder
    extends Request.Builder<QueryDeviceStatRequest, Builder> {
        private Long appKey;
        private String deviceType;
        private String endTime;
        private String queryType;
        private String startTime;

        private Builder() {
        }

        private Builder(QueryDeviceStatRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.deviceType = request.deviceType;
            this.endTime = request.endTime;
            this.queryType = request.queryType;
            this.startTime = request.startTime;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder deviceType(String deviceType) {
            this.putQueryParameter("DeviceType", deviceType);
            this.deviceType = deviceType;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder queryType(String queryType) {
            this.putQueryParameter("QueryType", queryType);
            this.queryType = queryType;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public QueryDeviceStatRequest build() {
            return new QueryDeviceStatRequest(this);
        }
    }
}

