/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.push20160801.models.PushTask;

public class PushV2Request
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="IdempotentToken")
    @Validation(maxLength=36, minLength=36)
    private String idempotentToken;
    @Query
    @NameInMap(value="PushTask")
    @Validation(required=true)
    private PushTask pushTask;

    private PushV2Request(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.idempotentToken = builder.idempotentToken;
        this.pushTask = builder.pushTask;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PushV2Request create() {
        return PushV2Request.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getIdempotentToken() {
        return this.idempotentToken;
    }

    public PushTask getPushTask() {
        return this.pushTask;
    }

    public static final class Builder
    extends Request.Builder<PushV2Request, Builder> {
        private Long appKey;
        private String idempotentToken;
        private PushTask pushTask;

        private Builder() {
        }

        private Builder(PushV2Request request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.idempotentToken = request.idempotentToken;
            this.pushTask = request.pushTask;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder idempotentToken(String idempotentToken) {
            this.putQueryParameter("IdempotentToken", idempotentToken);
            this.idempotentToken = idempotentToken;
            return this;
        }

        public Builder pushTask(PushTask pushTask) {
            String pushTaskShrink = this.shrink((Object)pushTask, "PushTask", "json");
            this.putQueryParameter("PushTask", pushTaskShrink);
            this.pushTask = pushTask;
            return this;
        }

        public PushV2Request build() {
            return new PushV2Request(this);
        }
    }
}

