/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ContinuouslyPushRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="MessageId")
    @Validation(required=true)
    private String messageId;
    @Query
    @NameInMap(value="Target")
    @Validation(required=true)
    private String target;
    @Query
    @NameInMap(value="TargetValue")
    @Validation(required=true)
    private String targetValue;

    private ContinuouslyPushRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.messageId = builder.messageId;
        this.target = builder.target;
        this.targetValue = builder.targetValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ContinuouslyPushRequest create() {
        return ContinuouslyPushRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public static final class Builder
    extends Request.Builder<ContinuouslyPushRequest, Builder> {
        private Long appKey;
        private String messageId;
        private String target;
        private String targetValue;

        private Builder() {
        }

        private Builder(ContinuouslyPushRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.messageId = request.messageId;
            this.target = request.target;
            this.targetValue = request.targetValue;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder messageId(String messageId) {
            this.putQueryParameter("MessageId", messageId);
            this.messageId = messageId;
            return this;
        }

        public Builder target(String target) {
            this.putQueryParameter("Target", target);
            this.target = target;
            return this;
        }

        public Builder targetValue(String targetValue) {
            this.putQueryParameter("TargetValue", targetValue);
            this.targetValue = targetValue;
            return this;
        }

        public ContinuouslyPushRequest build() {
            return new ContinuouslyPushRequest(this);
        }
    }
}

