/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CheckDevicesRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="DeviceIds")
    @Validation(required=true)
    private String deviceIds;

    private CheckDevicesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.deviceIds = builder.deviceIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CheckDevicesRequest create() {
        return CheckDevicesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getDeviceIds() {
        return this.deviceIds;
    }

    public static final class Builder
    extends Request.Builder<CheckDevicesRequest, Builder> {
        private Long appKey;
        private String deviceIds;

        private Builder() {
        }

        private Builder(CheckDevicesRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.deviceIds = request.deviceIds;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder deviceIds(String deviceIds) {
            this.putQueryParameter("DeviceIds", deviceIds);
            this.deviceIds = deviceIds;
            return this;
        }

        public CheckDevicesRequest build() {
            return new CheckDevicesRequest(this);
        }
    }
}

