/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class BindTagRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="ClientKey")
    @Validation(required=true)
    private String clientKey;
    @Query
    @NameInMap(value="KeyType")
    @Validation(required=true)
    private String keyType;
    @Query
    @NameInMap(value="TagName")
    @Validation(required=true)
    private String tagName;

    private BindTagRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.clientKey = builder.clientKey;
        this.keyType = builder.keyType;
        this.tagName = builder.tagName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BindTagRequest create() {
        return BindTagRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getTagName() {
        return this.tagName;
    }

    public static final class Builder
    extends Request.Builder<BindTagRequest, Builder> {
        private Long appKey;
        private String clientKey;
        private String keyType;
        private String tagName;

        private Builder() {
        }

        private Builder(BindTagRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.clientKey = request.clientKey;
            this.keyType = request.keyType;
            this.tagName = request.tagName;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder clientKey(String clientKey) {
            this.putQueryParameter("ClientKey", clientKey);
            this.clientKey = clientKey;
            return this;
        }

        public Builder keyType(String keyType) {
            this.putQueryParameter("KeyType", keyType);
            this.keyType = keyType;
            return this;
        }

        public Builder tagName(String tagName) {
            this.putQueryParameter("TagName", tagName);
            this.tagName = tagName;
            return this;
        }

        public BindTagRequest build() {
            return new BindTagRequest(this);
        }
    }
}

