/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util.asymmetric;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.asymmetric.BaseAsymmetricEncryptor;
import com.alipay.api.internal.util.codec.Base64;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;

public class SM2Encryptor
extends BaseAsymmetricEncryptor {
    public static final String SIGN_ALGORITHM = "SM3withSM2";
    public static String DEFAULT_USER_ID = "1234567812345678";
    public static final String PROVIDER_NAME = "BC";
    private static BouncyCastleProvider provider = new BouncyCastleProvider();

    @Override
    protected String getAsymmetricType() {
        return "SM2";
    }

    @Override
    protected String doDecrypt(String cipherTextBase64, String charset, String privateKey) throws Exception {
        byte[] cipher = Base64.decodeBase64String(cipherTextBase64);
        byte[] privateKeyByte = Base64.decodeBase64String(privateKey);
        PrivateKey sm2PrivateKey = SM2Encryptor.parsePKCS8PrivateKey(privateKeyByte);
        byte[] buf = SM2Encryptor.sm2Decrypt(cipher, sm2PrivateKey);
        try {
            String strContent = new String(buf, charset);
            return strContent;
        }
        catch (UnsupportedEncodingException e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
    }

    @Override
    protected String doEncrypt(String plainText, String charset, String publicKey) throws Exception {
        byte[] publicKeyByte = Base64.decodeBase64String(publicKey);
        PublicKey sm2PublicKey = SM2Encryptor.parseX509PublicKey(publicKeyByte);
        byte[] plain = plainText.getBytes(charset);
        byte[] cipher = SM2Encryptor.sm2Encrypt(plain, sm2PublicKey);
        String strContent = Base64.encodeBase64String(cipher);
        return strContent;
    }

    @Override
    protected String doSign(String content, String charset, String privateKey) throws Exception {
        byte[] privateKeyByte = Base64.decodeBase64String(privateKey);
        PrivateKey sm2PrivateKey = SM2Encryptor.parsePKCS8PrivateKey(privateKeyByte);
        byte[] message = content.getBytes(charset);
        byte[] signature = SM2Encryptor.sm2Sign(message, sm2PrivateKey, null);
        String sign = Base64.encodeBase64String(signature);
        return sign;
    }

    @Override
    protected boolean doVerify(String content, String charset, String publicKey, String sign) throws Exception {
        byte[] publicKeyByte;
        PublicKey sm2PublicKey;
        byte[] message;
        byte[] signature = Base64.decodeBase64String(sign);
        boolean valid = SM2Encryptor.sm2Verify(signature, message = content.getBytes(charset), sm2PublicKey = SM2Encryptor.parseX509PublicKey(publicKeyByte = Base64.decodeBase64String(publicKey)), null);
        if (!valid) {
            AlipayLogger.logBizError("\u9a8c\u7b7e\u5931\u8d25");
        }
        return valid;
    }

    private static byte[] sm2Encrypt(byte[] plain, PublicKey sm2PublicKey) throws AlipayApiException {
        try {
            Cipher sm2CipherEngine = Cipher.getInstance("SM2", PROVIDER_NAME);
            sm2CipherEngine.init(1, sm2PublicKey);
            return sm2CipherEngine.doFinal(plain);
        }
        catch (Exception e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
    }

    private static byte[] sm2Decrypt(byte[] cipher, PrivateKey sm2PrivateKey) throws AlipayApiException {
        try {
            Cipher sm2CipherEngine = Cipher.getInstance("SM2", PROVIDER_NAME);
            sm2CipherEngine.init(2, sm2PrivateKey);
            return sm2CipherEngine.doFinal(cipher);
        }
        catch (Exception e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
    }

    private static byte[] sm2Sign(byte[] message, PrivateKey sm2PrivateKey, String sm2UserId) throws AlipayApiException {
        try {
            String userId = DEFAULT_USER_ID;
            if (!StringUtils.isEmpty(sm2UserId)) {
                userId = sm2UserId;
            }
            Signature sm2SignEngine = Signature.getInstance(SIGN_ALGORITHM, PROVIDER_NAME);
            sm2SignEngine.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec(Strings.toByteArray((String)userId)));
            sm2SignEngine.initSign(sm2PrivateKey);
            sm2SignEngine.update(message);
            return sm2SignEngine.sign();
        }
        catch (Exception e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
    }

    private static boolean sm2Verify(byte[] signature, byte[] message, PublicKey publicKey, String sm2UserId) {
        try {
            String userId = DEFAULT_USER_ID;
            if (!StringUtils.isEmpty(sm2UserId)) {
                userId = sm2UserId;
            }
            Signature sm2SignEngine = Signature.getInstance(SIGN_ALGORITHM, PROVIDER_NAME);
            sm2SignEngine.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec(Strings.toByteArray((String)userId)));
            sm2SignEngine.initVerify(publicKey);
            sm2SignEngine.update(message);
            return sm2SignEngine.verify(signature);
        }
        catch (Exception e) {
            AlipayLogger.logBizError(e);
            return false;
        }
    }

    private static PublicKey parseX509PublicKey(byte[] x509PublicKey) throws AlipayApiException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(x509PublicKey);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
        catch (InvalidKeySpecException e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
    }

    private static PrivateKey parsePKCS8PrivateKey(byte[] pkcs8PriateKey) throws AlipayApiException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8PriateKey);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
        catch (InvalidKeySpecException e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
    }

    static {
        Security.addProvider((Provider)provider);
    }
}

