/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kms.aliyun;

import com.alipay.easysdk.kernel.util.Signer;
import com.alipay.easysdk.kms.aliyun.AliyunKMSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunKMSSigner
extends Signer {
    private AliyunKMSClient client;
    private static final Logger LOGGER = LoggerFactory.getLogger(Signer.class);

    public AliyunKMSSigner(AliyunKMSClient aliyunKmsClient) {
        this.client = aliyunKmsClient;
    }

    public String sign(String content, String privateKeyPem) {
        try {
            return this.client.sign(content);
        }
        catch (Exception e) {
            String errorMessage = "\u7b7e\u540d\u906d\u9047\u5f02\u5e38\uff0ccontent=" + content + " reason=" + e.getMessage();
            LOGGER.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public AliyunKMSClient getClient() {
        return this.client;
    }

    public void setClient(AliyunKMSClient client) {
        this.client = client;
    }
}

