/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis;

import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.RedisBroadcastManager;
import com.alicp.jetcache.redis.RedisCache;
import com.alicp.jetcache.redis.RedisCacheConfig;
import com.alicp.jetcache.support.BroadcastManager;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.util.Pool;

public class RedisCacheBuilder<T extends ExternalCacheBuilder<T>>
extends ExternalCacheBuilder<T> {
    public static RedisCacheBuilderImpl createRedisCacheBuilder() {
        return new RedisCacheBuilderImpl();
    }

    protected RedisCacheBuilder() {
        this.buildFunc(config -> new RedisCache((RedisCacheConfig)((Object)config)));
    }

    public RedisCacheConfig getConfig() {
        if (this.config == null) {
            this.config = new RedisCacheConfig();
        }
        return (RedisCacheConfig)this.config;
    }

    public boolean supportBroadcast() {
        return true;
    }

    public BroadcastManager createBroadcastManager(CacheManager cacheManager) {
        CacheConfig c = this.getConfig().clone();
        return new RedisBroadcastManager(cacheManager, (RedisCacheConfig)c);
    }

    public T jedisPool(Pool<Jedis> pool) {
        this.getConfig().setJedisPool(pool);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setJedisPool(Pool<Jedis> jedisPool) {
        this.getConfig().setJedisPool(jedisPool);
    }

    public T jedis(UnifiedJedis jedis) {
        this.getConfig().setJedis(jedis);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setJedis(UnifiedJedis jedis) {
        this.getConfig().setJedis(jedis);
    }

    public T readFromSlave(boolean readFromSlave) {
        this.getConfig().setReadFromSlave(readFromSlave);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setReadFromSlave(boolean readFromSlave) {
        this.getConfig().setReadFromSlave(readFromSlave);
    }

    public T jedisSlavePools(Pool<Jedis> ... jedisSlavePools) {
        this.getConfig().setJedisSlavePools(jedisSlavePools);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setJedisSlavePools(Pool<Jedis> ... jedisSlavePools) {
        this.getConfig().setJedisSlavePools(jedisSlavePools);
    }

    public T slaves(UnifiedJedis ... slaves) {
        this.getConfig().setSlaves(slaves);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setSlaves(UnifiedJedis ... slaves) {
        this.getConfig().setSlaves(slaves);
    }

    public T slaveReadWeights(int ... slaveReadWeights) {
        this.getConfig().setSlaveReadWeights(slaveReadWeights);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setSlaveReadWeights(int ... slaveReadWeights) {
        this.getConfig().setSlaveReadWeights(slaveReadWeights);
    }

    public static class RedisCacheBuilderImpl
    extends RedisCacheBuilder<RedisCacheBuilderImpl> {
    }
}

