/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis;

import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.redis.RedisCacheConfig;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.ClusterPipeline;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.commands.KeyBinaryCommands;
import redis.clients.jedis.commands.StringBinaryCommands;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.providers.ClusterConnectionProvider;
import redis.clients.jedis.util.Pool;

public class RedisCache<K, V>
extends AbstractExternalCache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(RedisCache.class);
    protected RedisCacheConfig<K, V> config;
    Function<Object, byte[]> valueEncoder;
    Function<byte[], Object> valueDecoder;
    ClusterConnectionProvider provider = null;
    private static ThreadLocalRandom random = ThreadLocalRandom.current();

    public RedisCache(RedisCacheConfig<K, V> config) {
        super(config);
        this.config = config;
        this.valueEncoder = config.getValueEncoder();
        this.valueDecoder = config.getValueDecoder();
        if (config.getJedis() == null && config.getJedisPool() == null) {
            throw new CacheConfigException("no jedis");
        }
        if (config.getJedis() != null && config.getJedisPool() != null) {
            throw new CacheConfigException("'jedis' and 'jedisPool' can't set simultaneously");
        }
        if (config.getJedis() != null && config.getJedisSlavePools() != null) {
            throw new CacheConfigException("'jedisSlavePools' should work with 'jedisPool' in RedisCacheConfig");
        }
        if (config.getJedisPool() != null && config.getSlaves() != null) {
            throw new CacheConfigException("'slaves' should work with 'jedis' in RedisCacheConfig");
        }
        if (config.isReadFromSlave()) {
            if (this.slaveCount() == 0) {
                throw new CacheConfigException("slaves not config");
            }
            if (config.getSlaveReadWeights() == null) {
                this.initDefaultWeights();
            } else if (config.getSlaveReadWeights().length != this.slaveCount()) {
                logger.error("length of slaveReadWeights and jedisSlavePools not equals, using default weights");
                this.initDefaultWeights();
            }
        }
        if (config.isExpireAfterAccess()) {
            throw new CacheConfigException("expireAfterAccess is not supported");
        }
        UnifiedJedis jedis = config.getJedis();
        if (jedis != null && jedis instanceof JedisCluster) {
            try {
                Field field = UnifiedJedis.class.getDeclaredField("provider");
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                this.provider = (ClusterConnectionProvider)field.get(jedis);
                field.setAccessible(accessible);
            }
            catch (Exception ex) {
                throw new IllegalStateException("can not get ConnectionProvider from JedisClient", ex);
            }
        }
    }

    private int slaveCount() {
        if (this.config.getSlaves() != null) {
            return this.config.getSlaves().length;
        }
        if (this.config.getJedisSlavePools() != null) {
            return this.config.getJedisSlavePools().length;
        }
        return 0;
    }

    private void initDefaultWeights() {
        int len = this.slaveCount();
        int[] weights = new int[len];
        Arrays.fill(weights, 100);
        this.config.setSlaveReadWeights(weights);
    }

    public CacheConfig<K, V> config() {
        return this.config;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (UnifiedJedis.class.isAssignableFrom(clazz)) {
            return (T)this.config.getJedis();
        }
        if (Pool.class.isAssignableFrom(clazz)) {
            return (T)this.config.getJedisPool();
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    Object writeCommands() {
        return this.config.getJedis() != null ? this.config.getJedis() : this.config.getJedisPool().getResource();
    }

    Object readCommands() {
        if (!this.config.isReadFromSlave()) {
            return this.writeCommands();
        }
        int[] weights = this.config.getSlaveReadWeights();
        int index = RedisCache.randomIndex(weights);
        if (this.config.getSlaves() != null) {
            return this.config.getSlaves()[index];
        }
        return this.config.getJedisSlavePools()[index].getResource();
    }

    static int randomIndex(int[] weights) {
        int sumOfWeights = 0;
        for (int w : weights) {
            sumOfWeights += w;
        }
        int r = random.nextInt(sumOfWeights);
        int x = 0;
        for (int i = 0; i < weights.length; ++i) {
            if (r >= (x += weights[i])) continue;
            return i;
        }
        throw new CacheException("assert false");
    }

    static void closeJedis(Object maybeJedis) {
        if (maybeJedis instanceof Jedis) {
            RedisCache.close((Closeable)((Jedis)maybeJedis));
        }
    }

    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("close jedis resource error: {}", (Object)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheGetResult<V> do_GET(K key) {
        CacheGetResult cacheGetResult;
        StringBinaryCommands commands;
        block6: {
            CacheValueHolder holder;
            block7: {
                commands = null;
                byte[] newKey = this.buildKey(key);
                commands = (StringBinaryCommands)this.readCommands();
                byte[] bytes = commands.get(newKey);
                if (bytes == null) break block6;
                holder = (CacheValueHolder)this.valueDecoder.apply(bytes);
                if (System.currentTimeMillis() < holder.getExpireTime()) break block7;
                CacheGetResult cacheGetResult2 = CacheGetResult.EXPIRED_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheGetResult2;
            }
            CacheGetResult cacheGetResult3 = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
            RedisCache.closeJedis(commands);
            return cacheGetResult3;
        }
        try {
            cacheGetResult = CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
        }
        catch (Exception ex) {
            CacheGetResult cacheGetResult4;
            try {
                this.logError("GET", key, ex);
                cacheGetResult4 = new CacheGetResult((Throwable)ex);
            }
            catch (Throwable throwable) {
                RedisCache.closeJedis(commands);
                throw throwable;
            }
            RedisCache.closeJedis(commands);
            return cacheGetResult4;
        }
        RedisCache.closeJedis(commands);
        return cacheGetResult;
    }

    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return new MultiGetResult(CacheResultCode.SUCCESS, null, Collections.emptyMap());
        }
        HashMap resultMap = new HashMap();
        try {
            StringBinaryCommands readCommands = (StringBinaryCommands)this.readCommands();
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(arg_0 -> ((RedisCache)this).buildKey(arg_0)).toArray(x$0 -> new byte[x$0][]);
            return this.doWithPipeline(readCommands, false, pipeline -> {
                List results;
                if (pipeline != null) {
                    ArrayList<Response> responseList = new ArrayList<Response>();
                    for (byte[] newKey : newKeys) {
                        Response response = pipeline.get(newKey);
                        responseList.add(response);
                    }
                    this.sync(pipeline);
                    results = responseList.stream().map(Response::get).collect(Collectors.toList());
                } else {
                    results = readCommands.mget(newKeys);
                }
                for (int i = 0; i < results.size(); ++i) {
                    Object value = results.get(i);
                    Object key = keyList.get(i);
                    if (value != null) {
                        CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply((byte[])value);
                        if (System.currentTimeMillis() >= holder.getExpireTime()) {
                            resultMap.put(key, CacheGetResult.EXPIRED_WITHOUT_MSG);
                            continue;
                        }
                        CacheGetResult r = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                        resultMap.put(key, r);
                        continue;
                    }
                    resultMap.put(key, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                }
                return new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
            });
        }
        catch (Exception ex) {
            this.logError("GET_ALL", "keys(" + keys.size() + ")", ex);
            if (!resultMap.isEmpty()) {
                return new MultiGetResult(CacheResultCode.PART_SUCCESS, ex.toString(), resultMap);
            }
            return new MultiGetResult((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        CacheResult cacheResult;
        StringBinaryCommands commands = null;
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            commands = (StringBinaryCommands)this.writeCommands();
            String rt = commands.psetex(newKey, timeUnit.toMillis(expireAfterWrite), this.valueEncoder.apply(holder));
            if ("OK".equals(rt)) {
                CacheResult cacheResult2 = CacheResult.SUCCESS_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheResult2;
            }
            cacheResult = new CacheResult(CacheResultCode.FAIL, rt);
            RedisCache.closeJedis(commands);
        }
        catch (Exception ex) {
            this.logError("PUT", key, ex);
            CacheResult cacheResult3 = new CacheResult((Throwable)ex);
            return cacheResult3;
        }
        finally {
            RedisCache.closeJedis(commands);
        }
        return cacheResult;
    }

    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        if (map == null || map.isEmpty()) {
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        try {
            StringBinaryCommands writeCommands = (StringBinaryCommands)this.writeCommands();
            return this.doWithPipeline(writeCommands, true, pipeline -> {
                int failCount = 0;
                ArrayList<Response> responses = new ArrayList<Response>();
                for (Map.Entry en : map.entrySet()) {
                    CacheValueHolder holder = new CacheValueHolder(en.getValue(), timeUnit.toMillis(expireAfterWrite));
                    Response resp = pipeline.psetex(this.buildKey(en.getKey()), timeUnit.toMillis(expireAfterWrite), this.valueEncoder.apply(holder));
                    responses.add(resp);
                }
                this.sync(pipeline);
                for (Response resp : responses) {
                    if ("OK".equals(resp.get())) continue;
                    ++failCount;
                }
                return failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == map.size() ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
            });
        }
        catch (Exception ex) {
            this.logError("PUT_ALL", "map(" + map.size() + ")", ex);
            return new CacheResult((Throwable)ex);
        }
    }

    protected CacheResult do_REMOVE(K key) {
        return this.REMOVE_impl(key, this.buildKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheResult REMOVE_impl(Object key, byte[] newKey) {
        KeyBinaryCommands commands = null;
        try {
            commands = (KeyBinaryCommands)this.writeCommands();
            Long rt = commands.del(newKey);
            if (rt == null) {
                CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
                return cacheResult;
            }
            if (rt == 1L) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            if (rt == 0L) {
                CacheResult cacheResult = new CacheResult(CacheResultCode.NOT_EXISTS, null);
                return cacheResult;
            }
            CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("REMOVE", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            RedisCache.closeJedis(commands);
        }
    }

    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        long[] count = new long[1];
        try {
            KeyBinaryCommands writeCommands = (KeyBinaryCommands)this.writeCommands();
            byte[][] newKeys = (byte[][])keys.stream().map(k -> this.buildKey(k)).toArray(len -> new byte[keys.size()][]);
            return this.doWithPipeline(writeCommands, false, pipeline -> {
                if (pipeline != null) {
                    for (byte[] newKey : newKeys) {
                        pipeline.del(newKey);
                        count[0] = count[0] + 1L;
                    }
                    this.sync(pipeline);
                } else {
                    writeCommands.del(newKeys);
                }
                return CacheResult.SUCCESS_WITHOUT_MSG;
            });
        }
        catch (Exception ex) {
            this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", ex);
            if (count[0] > 0L) {
                return new CacheResult(CacheResultCode.PART_SUCCESS, ex.toString());
            }
            return new CacheResult((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        StringBinaryCommands commands = null;
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            SetParams params = new SetParams();
            params.nx().px(timeUnit.toMillis(expireAfterWrite));
            commands = (StringBinaryCommands)this.writeCommands();
            String rt = commands.set(newKey, this.valueEncoder.apply(holder), params);
            if ("OK".equals(rt)) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheResult;
            }
            if (rt == null) {
                CacheResult cacheResult = CacheResult.EXISTS_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheResult;
            }
            CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, rt);
            RedisCache.closeJedis(commands);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT_IF_ABSENT", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            RedisCache.closeJedis(commands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C, P, R> R doWithPipeline(C client, boolean pipelineFirst, Function<P, R> function) {
        R r;
        Object commands = null;
        ClusterPipeline closeable = null;
        try {
            commands = client;
            ClusterPipeline pipeline = null;
            if (commands instanceof JedisCluster) {
                ClusterPipeline clusterPipeline;
                closeable = clusterPipeline = new ClusterPipeline(this.provider);
                pipeline = clusterPipeline;
            } else if (pipelineFirst) {
                if (commands instanceof JedisPooled) {
                    Connection connection = (Connection)((JedisPooled)commands).getPool().getResource();
                    closeable = connection;
                    pipeline = new Pipeline(connection);
                } else if (commands instanceof Jedis) {
                    pipeline = new Pipeline((Jedis)commands);
                }
            }
            r = function.apply(pipeline);
        }
        catch (Throwable throwable) {
            RedisCache.closeJedis(commands);
            RedisCache.close(closeable);
            throw throwable;
        }
        RedisCache.closeJedis(commands);
        RedisCache.close((Closeable)closeable);
        return r;
    }

    private <T> void sync(T pipeline) {
        if (pipeline instanceof Pipeline) {
            ((Pipeline)pipeline).sync();
        } else if (pipeline instanceof ClusterPipeline) {
            ((ClusterPipeline)pipeline).sync();
        } else {
            throw new UnsupportedOperationException("unrecognized pipeline type");
        }
    }
}

