/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.alicp.jetcache.support.ObjectPool;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.CompatibleFieldSerializer;

public class Kryo5ValueEncoder
extends AbstractValueEncoder {
    public static final Kryo5ValueEncoder INSTANCE = new Kryo5ValueEncoder(true);
    private static final int INIT_BUFFER_SIZE = 2048;
    static ObjectPool<Kryo5Cache> kryoCacheObjectPool = new ObjectPool<Kryo5Cache>(16, new ObjectPool.ObjectFactory<Kryo5Cache>(){

        @Override
        public Kryo5Cache create() {
            return new Kryo5Cache();
        }

        @Override
        public void reset(Kryo5Cache obj) {
            obj.getKryo().reset();
            obj.getOutput().reset();
        }
    });

    public Kryo5ValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    @Override
    public byte[] apply(Object value) {
        Kryo5Cache kryoCache = null;
        try {
            kryoCache = kryoCacheObjectPool.borrowObject();
            if (this.useIdentityNumber) {
                this.writeInt(kryoCache.getOutput(), -153049664);
            }
            kryoCache.getKryo().writeClassAndObject(kryoCache.getOutput(), value);
            byte[] byArray = kryoCache.getOutput().toBytes();
            return byArray;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Kryo Encode error. ");
            sb.append("msg=").append(e.getMessage());
            throw new CacheEncodeException(sb.toString(), e);
        }
        finally {
            if (kryoCache != null) {
                kryoCacheObjectPool.returnObject(kryoCache);
            }
        }
    }

    private void writeInt(Output output, int value) {
        output.writeByte(value >>> 24);
        output.writeByte(value >>> 16);
        output.writeByte(value >>> 8);
        output.writeByte(value);
    }

    public static class Kryo5Cache {
        final Output output;
        final Kryo kryo = new Kryo();

        public Kryo5Cache() {
            this.kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
            this.kryo.setRegistrationRequired(false);
            this.output = new Output(2048, -1);
        }

        public Output getOutput() {
            return this.output;
        }

        public Kryo getKryo() {
            return this.kryo;
        }
    }
}

