/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.MultiLevelCacheConfig;
import com.alicp.jetcache.ResultData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class MultiLevelCache<K, V>
extends AbstractCache<K, V> {
    private Cache[] caches;
    private MultiLevelCacheConfig<K, V> config;

    @Deprecated
    public MultiLevelCache(Cache ... caches) throws CacheConfigException {
        this.caches = caches;
        this.checkCaches();
        CacheConfig lastConfig = caches[caches.length - 1].config();
        this.config = new MultiLevelCacheConfig();
        this.config.setCaches(Arrays.asList(caches));
        this.config.setExpireAfterWriteInMillis(lastConfig.getExpireAfterWriteInMillis());
        this.config.setCacheNullValue(lastConfig.isCacheNullValue());
    }

    public MultiLevelCache(MultiLevelCacheConfig<K, V> cacheConfig) throws CacheConfigException {
        this.config = cacheConfig;
        this.caches = cacheConfig.getCaches().toArray(new Cache[0]);
        this.checkCaches();
    }

    private void checkCaches() {
        if (this.caches == null || this.caches.length == 0) {
            throw new IllegalArgumentException();
        }
        for (Cache c : this.caches) {
            if (c.config().getLoader() == null) continue;
            throw new CacheConfigException("Loader on sub cache is not allowed, set the loader into MultiLevelCache.");
        }
    }

    public Cache[] caches() {
        return this.caches;
    }

    @Override
    public MultiLevelCacheConfig<K, V> config() {
        return this.config;
    }

    @Override
    public CacheResult PUT(K key, V value) {
        if (this.config.isUseExpireOfSubCache()) {
            return this.PUT(key, value, 0L, null);
        }
        return this.PUT(key, value, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CacheResult PUT_ALL(Map<? extends K, ? extends V> map) {
        if (this.config.isUseExpireOfSubCache()) {
            return this.PUT_ALL(map, 0L, null);
        }
        return this.PUT_ALL(map, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected CacheGetResult<V> do_GET(K key) {
        for (int i = 0; i < this.caches.length; ++i) {
            Cache cache = this.caches[i];
            CacheGetResult result = cache.GET(key);
            if (!result.isSuccess()) continue;
            CacheValueHolder holder = this.unwrapHolder(result.getHolder());
            this.checkResultAndFillUpperCache(key, i, holder);
            return new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
        }
        return CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
    }

    private CacheValueHolder<V> unwrapHolder(CacheValueHolder<V> h) {
        Objects.requireNonNull(h);
        if (h.getValue() instanceof CacheValueHolder) {
            return (CacheValueHolder)h.getValue();
        }
        return h;
    }

    private void checkResultAndFillUpperCache(K key, int i, CacheValueHolder<V> h) {
        Objects.requireNonNull(h);
        long currentExpire = h.getExpireTime();
        long now = System.currentTimeMillis();
        if (now <= currentExpire) {
            if (this.config.isUseExpireOfSubCache()) {
                this.PUT_caches(i, key, h.getValue(), 0L, null);
            } else {
                long restTtl = currentExpire - now;
                if (restTtl > 0L) {
                    this.PUT_caches(i, key, h.getValue(), restTtl, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    @Override
    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        HashMap<Object, CacheGetResult> resultMap = new HashMap<Object, CacheGetResult>();
        HashSet<K> restKeys = new HashSet<K>(keys);
        for (int i = 0; i < this.caches.length && restKeys.size() != 0; ++i) {
            Cache c = this.caches[i];
            MultiGetResult allResult = c.GET_ALL(restKeys);
            if (!allResult.isSuccess() || allResult.getValues() == null) continue;
            for (Map.Entry en : allResult.getValues().entrySet()) {
                K key = en.getKey();
                CacheGetResult result = en.getValue();
                if (!result.isSuccess()) continue;
                CacheValueHolder holder = this.unwrapHolder(result.getHolder());
                this.checkResultAndFillUpperCache(key, i, holder);
                resultMap.put(key, new CacheGetResult(CacheResultCode.SUCCESS, null, holder));
                restKeys.remove(key);
            }
        }
        for (Object k : restKeys) {
            resultMap.put(k, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
        }
        return new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
    }

    @Override
    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        return this.PUT_caches(this.caches.length, key, value, expireAfterWrite, timeUnit);
    }

    @Override
    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        for (Cache c : this.caches) {
            CacheResult r = timeUnit == null ? c.PUT_ALL(map) : c.PUT_ALL(map, expireAfterWrite, timeUnit);
            future = this.combine(future, r);
        }
        return new CacheResult(future);
    }

    private CacheResult PUT_caches(int lastIndex, K key, V value, long expire, TimeUnit timeUnit) {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        for (int i = 0; i < lastIndex; ++i) {
            Cache cache = this.caches[i];
            CacheResult r = timeUnit == null ? cache.PUT(key, value) : cache.PUT(key, value, expire, timeUnit);
            future = this.combine(future, r);
        }
        return new CacheResult(future);
    }

    private CompletableFuture<ResultData> combine(CompletableFuture<ResultData> future, CacheResult result) {
        return future.thenCombine(result.future(), (d1, d2) -> {
            if (d1 == null) {
                return d2;
            }
            if (d1.getResultCode() != d2.getResultCode()) {
                return new ResultData(CacheResultCode.PART_SUCCESS, null, null);
            }
            return d1;
        });
    }

    @Override
    protected CacheResult do_REMOVE(K key) {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        for (Cache cache : this.caches) {
            CacheResult r = cache.REMOVE(key);
            future = this.combine(future, r);
        }
        return new CacheResult(future);
    }

    @Override
    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        for (Cache cache : this.caches) {
            CacheResult r = cache.REMOVE_ALL(keys);
            future = this.combine(future, r);
        }
        return new CacheResult(future);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        for (Cache cache : this.caches) {
            try {
                T obj = cache.unwrap(clazz);
                if (obj == null) continue;
                return obj;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    @Override
    public AutoReleaseLock tryLock(K key, long expire, TimeUnit timeUnit) {
        if (key == null) {
            return null;
        }
        return this.caches[this.caches.length - 1].tryLock(key, expire, timeUnit);
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException("putIfAbsent is not supported by MultiLevelCache");
    }

    @Override
    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("PUT_IF_ABSENT is not supported by MultiLevelCache");
    }

    @Override
    public void close() {
        super.close();
        for (Cache c : this.caches) {
            c.close();
        }
    }
}

