/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.anno.method.EL;
import com.alicp.jetcache.anno.method.MvelEvaluator;
import com.alicp.jetcache.anno.method.SpelEvaluator;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionEvaluator
implements Function<Object, Object> {
    private static final Pattern pattern = Pattern.compile("\\s*(\\w+)\\s*\\{(.+)\\}\\s*");
    private Function<Object, Object> target;

    public ExpressionEvaluator(String script, Method defineMethod) {
        Object[] rt = this.parseEL(script);
        EL el = (EL)((Object)rt[0]);
        String realScript = (String)rt[1];
        if (el == EL.MVEL) {
            this.target = new MvelEvaluator(realScript);
        } else if (el == EL.SPRING_EL) {
            this.target = new SpelEvaluator(realScript, defineMethod);
        }
    }

    private Object[] parseEL(String script) {
        if (script == null || script.trim().equals("")) {
            return null;
        }
        Object[] rt = new Object[2];
        Matcher matcher = pattern.matcher(script);
        if (!matcher.matches()) {
            rt[0] = EL.SPRING_EL;
            rt[1] = script;
            return rt;
        }
        String s = matcher.group(1);
        if ("spel".equals(s)) {
            rt[0] = EL.SPRING_EL;
        } else if ("mvel".equals(s)) {
            rt[0] = EL.MVEL;
        } else {
            throw new CacheConfigException("Can't parse \"" + script + "\"");
        }
        rt[1] = matcher.group(2);
        return rt;
    }

    @Override
    public Object apply(Object o) {
        return this.target.apply(o);
    }

    Function<Object, Object> getTarget() {
        return this.target;
    }
}

