/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.tts;

import com.alibaba.nls.client.protocol.NlsClient;
import com.alibaba.nls.client.protocol.OutputFormatEnum;
import com.alibaba.nls.client.protocol.SampleRateEnum;
import com.alibaba.nls.client.protocol.SpeechReqProtocol;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizerListener;
import com.alibaba.nls.client.transport.Connection;
import com.alibaba.nls.client.transport.ConnectionListener;
import com.alibaba.nls.client.util.IdGen;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechSynthesizer
extends SpeechReqProtocol {
    static Logger logger = LoggerFactory.getLogger(SpeechSynthesizer.class);
    private Connection conn;
    private SpeechSynthesizerListener listener;
    private CountDownLatch completeLatch;
    private static final String DEFAULT_FORMAT = "pcm";
    private static final Integer DEFAULT_SAMPLE_RATE = 16000;
    private static final Integer DEFAULT_VOICE_VOLUME = 50;

    public SpeechSynthesizer(NlsClient client, SpeechSynthesizerListener listener) throws Exception {
        this.conn = client.connect((ConnectionListener)listener);
        this.listener = listener;
        this.payload = new HashMap();
        this.header.put("namespace", "SpeechSynthesizer");
        this.header.put("name", "StartSynthesis");
        this.payload.put("format", DEFAULT_FORMAT);
        this.payload.put("sample_rate", DEFAULT_SAMPLE_RATE);
        this.payload.put("volume", DEFAULT_VOICE_VOLUME);
        listener.setSpeechSynthesizer(this);
        this.state = SpeechReqProtocol.State.STATE_CONNECTED;
    }

    public void setVoice(String voice) {
        this.payload.put("voice", voice);
    }

    public void setText(String text) {
        this.payload.put("text", text);
    }

    public void setFormat(OutputFormatEnum format) {
        this.payload.put("format", format.getName());
    }

    public void setSampleRate(SampleRateEnum sampleRate) {
        this.payload.put("sample_rate", sampleRate.value);
    }

    public void setSampleRate(int sampleRate) {
        this.payload.put("sample_rate", sampleRate);
    }

    public void setVolume(int volume) {
        this.payload.put("volume", volume);
    }

    public void setSpeechRate(int speechRate) {
        this.payload.put("speech_rate", speechRate);
    }

    public void setPitchRate(int pitchRate) {
        this.payload.put("pitch_rate", pitchRate);
    }

    public void setMethod(int method) {
        this.payload.put("method", method);
    }

    public void start() throws Exception {
        String taskId;
        this.state.checkStart();
        this.currentTaskId = taskId = IdGen.genId();
        this.setTaskId(taskId);
        this.conn.sendText(this.serialize());
        this.completeLatch = new CountDownLatch(1);
        this.listener.setCompleteLatch(this.completeLatch);
    }

    public void waitForComplete(int seconds) throws Exception {
        this.completeLatch.await(seconds, TimeUnit.SECONDS);
    }

    public void waitForComplete() throws Exception {
        this.completeLatch.await();
    }

    public void close() {
        this.conn.close();
    }

    void markClosed() {
        this.state = SpeechReqProtocol.State.STATE_CLOSED;
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }
}

