/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol;

import com.alibaba.nls.client.transport.Connection;
import com.alibaba.nls.client.transport.ConnectionListener;
import com.alibaba.nls.client.transport.netty4.NettyWebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NlsClient {
    static Logger logger = LoggerFactory.getLogger(NlsClient.class);
    private static final String DEFAULT_SERVER_ADDR = "wss://nls-gateway.cn-shanghai.aliyuncs.com/ws/v1";
    NettyWebSocketClient client;
    String token;
    public int DEFAULT_CONNECTION_TIMEOUT = 5000;

    public NlsClient(String token) {
        try {
            this.token = token;
            this.client = new NettyWebSocketClient(DEFAULT_SERVER_ADDR);
        }
        catch (Exception e) {
            logger.error("fail to create NlsClient", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public NlsClient(String url, String token) {
        try {
            this.token = token;
            this.client = new NettyWebSocketClient(url);
        }
        catch (Exception e) {
            logger.error("fail to create NlsClient", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Connection connect(ConnectionListener listener) throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                return this.client.connect(this.token, listener, this.DEFAULT_CONNECTION_TIMEOUT);
            }
            catch (Exception e) {
                if (i == 2) {
                    logger.error("failed to connect to server after 3 tries,error msg is :{}", (Object)e.getMessage());
                    throw e;
                }
                Thread.sleep(100L);
                logger.warn("failed to connect to server the {} time:{} ,try again ", (Object)i, (Object)e.getMessage());
                continue;
            }
        }
        return null;
    }

    public void shutdown() {
        this.client.shutdown();
    }
}

