/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps.barrier;

import com.alibaba.nacos.plugin.control.tps.MonitorType;
import com.alibaba.nacos.plugin.control.tps.TpsMetrics;
import com.alibaba.nacos.plugin.control.tps.barrier.RateCounter;
import com.alibaba.nacos.plugin.control.tps.barrier.RuleBarrier;
import com.alibaba.nacos.plugin.control.tps.request.BarrierCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import com.alibaba.nacos.plugin.control.tps.rule.RuleDetail;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class SimpleCountRuleBarrier
extends RuleBarrier {
    RateCounter rateCounter;

    public SimpleCountRuleBarrier(String pointName, String ruleName, TimeUnit period) {
        super.setPointName(pointName);
        super.setPeriod(period);
        super.setRuleName(ruleName);
        this.rateCounter = this.createSimpleCounter(ruleName, period);
    }

    public abstract RateCounter createSimpleCounter(String var1, TimeUnit var2);

    public void reCreateRaterCounter(String name, TimeUnit period) {
        this.rateCounter = this.createSimpleCounter(name, period);
    }

    @Override
    public TpsCheckResponse applyTps(BarrierCheckRequest barrierCheckRequest) {
        if (MonitorType.INTERCEPT.getType().equals(this.getMonitorType())) {
            long maxCount = this.getMaxCount();
            boolean accepted = this.rateCounter.tryAdd(barrierCheckRequest.getTimestamp(), barrierCheckRequest.getCount(), maxCount);
            return accepted ? new TpsCheckResponse(true, 200, "success") : new TpsCheckResponse(false, 300, "tps over limit :" + maxCount);
        }
        this.rateCounter.add(barrierCheckRequest.getTimestamp(), barrierCheckRequest.getCount());
        return new TpsCheckResponse(true, 200, "success");
    }

    long trimTimeStamp(long timeStamp) {
        timeStamp = this.getPeriod() == TimeUnit.SECONDS ? RateCounter.getTrimMillsOfSecond(timeStamp) : (this.getPeriod() == TimeUnit.MINUTES ? RateCounter.getTrimMillsOfMinute(timeStamp) : (this.getPeriod() == TimeUnit.HOURS ? RateCounter.getTrimMillsOfHour(timeStamp) : RateCounter.getTrimMillsOfSecond(timeStamp)));
        return timeStamp;
    }

    @Override
    public TpsMetrics getMetrics(long timeStamp) {
        timeStamp = this.trimTimeStamp(timeStamp);
        TpsMetrics tpsMetrics = new TpsMetrics("", "", timeStamp, super.getPeriod());
        long totalPass = this.rateCounter.getCount(timeStamp);
        if (totalPass <= 0L) {
            return null;
        }
        tpsMetrics.setCounter(new TpsMetrics.Counter(totalPass, 0L));
        return tpsMetrics;
    }

    @Override
    public void applyRuleDetail(RuleDetail ruleDetail) {
        if (!Objects.equals((Object)this.getPeriod(), (Object)ruleDetail.getPeriod())) {
            this.setMaxCount(ruleDetail.getMaxCount());
            this.setMonitorType(ruleDetail.getMonitorType());
            this.setPeriod(ruleDetail.getPeriod());
            this.reCreateRaterCounter(ruleDetail.getRuleName(), this.getPeriod());
        } else {
            this.setMaxCount(ruleDetail.getMaxCount());
            this.setMonitorType(ruleDetail.getMonitorType());
        }
    }
}

