/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class BatchTaskCounter {
    List<AtomicBoolean> batchCounter;

    public BatchTaskCounter(int totalBatch) {
        this.initBatchCounter(totalBatch);
    }

    private void initBatchCounter(int totalBatch) {
        this.batchCounter = new ArrayList<AtomicBoolean>(totalBatch);
        for (int i = 0; i < totalBatch; ++i) {
            this.batchCounter.add(i, new AtomicBoolean(false));
        }
    }

    public void batchSuccess(int batch) {
        if (batch <= this.batchCounter.size()) {
            this.batchCounter.get(batch - 1).set(true);
        }
    }

    public boolean batchCompleted() {
        for (AtomicBoolean atomicBoolean : this.batchCounter) {
            if (atomicBoolean.get()) continue;
            return false;
        }
        return true;
    }

    public int getTotalBatch() {
        return this.batchCounter.size();
    }
}

