/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.paramcheck;

import com.alibaba.nacos.common.paramcheck.AbstractParamChecker;
import com.alibaba.nacos.common.paramcheck.ParamCheckResponse;
import com.alibaba.nacos.common.paramcheck.ParamCheckRule;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.common.utils.NumberUtils;
import com.alibaba.nacos.common.utils.PropertyUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DefaultParamChecker
extends AbstractParamChecker {
    private Pattern namespaceShowNamePattern;
    private Pattern namespaceIdPattern;
    private Pattern dataIdPattern;
    private Pattern serviceNamePattern;
    private Pattern groupPattern;
    private Pattern clusterPattern;
    private Pattern ipPattern;
    private Pattern mcpNamePattern;
    private static final String CHECKER_TYPE = "default";
    private static final String MAX_METADATA_LENGTH_PROP_NAME = "nacos.naming.service.metadata.length";
    private static final String MAX_METADATA_LENGTH_ENV_NAME = "NACOS_NAMING_SERVICE_METADATA_LENGTH";

    @Override
    public String getCheckerType() {
        return CHECKER_TYPE;
    }

    @Override
    public ParamCheckResponse checkParamInfoList(List<ParamInfo> paramInfos) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (paramInfos == null) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        for (ParamInfo paramInfo : paramInfos) {
            paramCheckResponse = this.checkParamInfoFormat(paramInfo);
            if (paramCheckResponse.isSuccess()) continue;
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    @Override
    public void initParamCheckRule() {
        this.paramCheckRule = new ParamCheckRule();
        this.initFormatPattern();
        this.replaceParamCheckRuleByEnv();
    }

    private void initFormatPattern() {
        this.namespaceShowNamePattern = Pattern.compile(this.paramCheckRule.namespaceShowNamePatternString);
        this.namespaceIdPattern = Pattern.compile(this.paramCheckRule.namespaceIdPatternString);
        this.dataIdPattern = Pattern.compile(this.paramCheckRule.dataIdPatternString);
        this.serviceNamePattern = Pattern.compile(this.paramCheckRule.serviceNamePatternString);
        this.groupPattern = Pattern.compile(this.paramCheckRule.groupPatternString);
        this.clusterPattern = Pattern.compile(this.paramCheckRule.clusterPatternString);
        this.ipPattern = Pattern.compile(this.paramCheckRule.ipPatternString);
        this.mcpNamePattern = Pattern.compile(this.paramCheckRule.clusterPatternString);
    }

    private void replaceParamCheckRuleByEnv() {
        String maxMetadataLength = PropertyUtils.getProperty(MAX_METADATA_LENGTH_PROP_NAME, MAX_METADATA_LENGTH_ENV_NAME);
        if (StringUtils.isNotBlank(maxMetadataLength)) {
            this.paramCheckRule.maxMetadataLength = NumberUtils.toInt(maxMetadataLength);
        }
    }

    public ParamCheckResponse checkParamInfoFormat(ParamInfo paramInfo) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (paramInfo == null) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkNamespaceShowNameFormat(paramInfo.getNamespaceShowName());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkNamespaceIdFormat(paramInfo.getNamespaceId());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkDataIdFormat(paramInfo.getDataId());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkServiceNameFormat(paramInfo.getServiceName());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkGroupFormat(paramInfo.getGroup());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkClusterFormat(paramInfo.getClusters());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkSingleClusterFormat(paramInfo.getCluster());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkIpFormat(paramInfo.getIp());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkPortFormat(paramInfo.getPort());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkMetadataFormat(paramInfo.getMetadata());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse = this.checkMcpNameFormat(paramInfo.getMcpName());
        if (!paramCheckResponse.isSuccess()) {
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkNamespaceShowNameFormat(String namespaceShowName) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(namespaceShowName)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (namespaceShowName.length() > this.paramCheckRule.maxNamespaceShowNameLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'namespaceShowName' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxNamespaceShowNameLength));
            return paramCheckResponse;
        }
        if (!this.namespaceShowNamePattern.matcher(namespaceShowName).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'namespaceShowName' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkNamespaceIdFormat(String namespaceId) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(namespaceId)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (namespaceId.length() > this.paramCheckRule.maxNamespaceIdLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'namespaceId/tenant' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxNamespaceIdLength));
            return paramCheckResponse;
        }
        if (!this.namespaceIdPattern.matcher(namespaceId).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'namespaceId/tenant' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkDataIdFormat(String dataId) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(dataId)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (dataId.length() > this.paramCheckRule.maxDataIdLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'dataId' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxDataIdLength));
            return paramCheckResponse;
        }
        if (!this.dataIdPattern.matcher(dataId).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'dataId' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkServiceNameFormat(String serviceName) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(serviceName)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (serviceName.length() > this.paramCheckRule.maxServiceNameLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'serviceName' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxServiceNameLength));
            return paramCheckResponse;
        }
        if (!this.serviceNamePattern.matcher(serviceName).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'serviceName' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkGroupFormat(String group) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(group)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (group.length() > this.paramCheckRule.maxGroupLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'group' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxGroupLength));
            return paramCheckResponse;
        }
        if (!this.groupPattern.matcher(group).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'group' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkClusterFormat(String clusterString) {
        String[] clusters;
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(clusterString)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        for (String cluster : clusters = clusterString.split(",")) {
            paramCheckResponse = this.checkSingleClusterFormat(cluster);
            if (paramCheckResponse.isSuccess()) continue;
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkSingleClusterFormat(String cluster) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(cluster)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (cluster.length() > this.paramCheckRule.maxClusterLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'cluster' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxClusterLength));
            return paramCheckResponse;
        }
        if (!this.clusterPattern.matcher(cluster).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'cluster' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkIpFormat(String ip) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(ip)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (ip.length() > this.paramCheckRule.maxIpLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'ip' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxIpLength));
            return paramCheckResponse;
        }
        if (!this.ipPattern.matcher(ip).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'ip' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkPortFormat(String port) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(port)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        int portInt = 0;
        try {
            portInt = Integer.parseInt(port);
        }
        catch (Exception e) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'port' is illegal, the value should be between %d and %d.", this.paramCheckRule.minPort, this.paramCheckRule.maxPort));
            return paramCheckResponse;
        }
        if (portInt > this.paramCheckRule.maxPort || portInt < this.paramCheckRule.minPort) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'port' is illegal, the value should be between %d and %d.", this.paramCheckRule.minPort, this.paramCheckRule.maxPort));
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkMetadataFormat(Map<String, String> metadata) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (metadata == null || metadata.isEmpty()) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        int totalLength = 0;
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            if (StringUtils.isNotBlank(entry.getKey())) {
                totalLength += entry.getKey().length();
            }
            if (!StringUtils.isNotBlank(entry.getValue())) continue;
            totalLength += entry.getValue().length();
        }
        if (totalLength > this.paramCheckRule.maxMetadataLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'Metadata' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxMetadataLength));
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }

    public ParamCheckResponse checkMcpNameFormat(String mcpName) {
        ParamCheckResponse paramCheckResponse = new ParamCheckResponse();
        if (StringUtils.isBlank(mcpName)) {
            paramCheckResponse.setSuccess(true);
            return paramCheckResponse;
        }
        if (mcpName.length() > this.paramCheckRule.maxClusterLength) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage(String.format("Param 'mcpName' is illegal, the param length should not exceed %d.", this.paramCheckRule.maxClusterLength));
            return paramCheckResponse;
        }
        if (!this.mcpNamePattern.matcher(mcpName).matches()) {
            paramCheckResponse.setSuccess(false);
            paramCheckResponse.setMessage("Param 'mcpName' is illegal, illegal characters should not appear in the param.");
            return paramCheckResponse;
        }
        paramCheckResponse.setSuccess(true);
        return paramCheckResponse;
    }
}

