/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TopnCounterMetricsContainer {
    private ConcurrentHashMap<String, AtomicInteger> dataCount = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, DoublyLinkedNode> specifiedCountDataIdSets = new ConcurrentHashMap();
    private DoublyLinkedNode dummyHead = new DoublyLinkedNode(null, null, null, -1);

    public TopnCounterMetricsContainer() {
        this.dummyHead.next = new DoublyLinkedNode(null, this.dummyHead, new ConcurrentHashSet<String>(), 0);
        this.specifiedCountDataIdSets.put(0, this.dummyHead.next);
    }

    public List<Pair<String, AtomicInteger>> getTopNCounter(int n) {
        LinkedList<Pair<String, AtomicInteger>> topnCounter = new LinkedList<Pair<String, AtomicInteger>>();
        DoublyLinkedNode curr = this.dummyHead;
        while (curr.next != null && topnCounter.size() < n) {
            for (String dataId : curr.next.dataSet) {
                topnCounter.add(new Pair<String, AtomicInteger>(dataId, this.dataCount.get(dataId)));
                if (topnCounter.size() != n) continue;
                break;
            }
            curr = curr.next;
        }
        return topnCounter;
    }

    public void put(String dataId) {
        this.put(dataId, 0);
    }

    public void put(String dataId, int count) {
        if (this.dataCount.containsKey(dataId)) {
            this.removeFromSpecifiedCountDataIdSets(dataId);
            this.dataCount.get(dataId).set(count);
        } else {
            this.dataCount.put(dataId, new AtomicInteger(count));
        }
        this.insertIntoSpecifiedCountDataIdSets(dataId, count);
    }

    public int get(String dataId) {
        if (this.dataCount.containsKey(dataId)) {
            return this.dataCount.get(dataId).get();
        }
        return -1;
    }

    public void increment(String dataId) {
        if (!this.dataCount.containsKey(dataId)) {
            this.put(dataId);
        }
        DoublyLinkedNode prev = this.removeFromSpecifiedCountDataIdSets(dataId);
        int newCount = this.dataCount.get(dataId).incrementAndGet();
        if (!this.isDummyHead(prev) && prev.count == newCount) {
            this.insertIntoSpecifiedCountDataIdSets(dataId, prev);
        } else {
            DoublyLinkedNode newNode = new DoublyLinkedNode(prev.next, prev, new ConcurrentHashSet<String>(), newCount);
            if (prev.next != null) {
                prev.next.prev = newNode;
            }
            prev.next = newNode;
            newNode.dataSet.add(dataId);
            this.specifiedCountDataIdSets.put(newCount, newNode);
        }
    }

    public AtomicInteger remove(String dataId) {
        if (this.dataCount.containsKey(dataId)) {
            this.removeFromSpecifiedCountDataIdSets(dataId);
            return this.dataCount.remove(dataId);
        }
        return null;
    }

    public void removeAll() {
        for (String dataId : this.dataCount.keySet()) {
            this.removeFromSpecifiedCountDataIdSets(dataId);
        }
        this.dataCount.clear();
    }

    private DoublyLinkedNode removeFromSpecifiedCountDataIdSets(String dataId) {
        int count = this.dataCount.get(dataId).get();
        DoublyLinkedNode node = this.specifiedCountDataIdSets.get(count);
        node.dataSet.remove(dataId);
        if (node.dataSet.size() == 0 && node.count != 0) {
            node.prev.next = node.next;
            if (node.next != null) {
                node.next.prev = node.prev;
            }
            this.specifiedCountDataIdSets.remove(node.count);
        }
        return node.prev;
    }

    private void insertIntoSpecifiedCountDataIdSets(String dataId, int count) {
        if (this.specifiedCountDataIdSets.containsKey(count)) {
            this.specifiedCountDataIdSets.get((Object)Integer.valueOf((int)count)).dataSet.add(dataId);
        } else {
            DoublyLinkedNode prev = this.dummyHead;
            while (prev.next != null && prev.next.count >= count) {
                prev = prev.next;
            }
            DoublyLinkedNode newNode = new DoublyLinkedNode(prev.next, prev, new ConcurrentHashSet<String>(), count);
            if (prev.next != null) {
                prev.next.prev = newNode;
            }
            prev.next = newNode;
            newNode.dataSet.add(dataId);
            this.specifiedCountDataIdSets.put(count, newNode);
        }
    }

    private void insertIntoSpecifiedCountDataIdSets(String dataId, DoublyLinkedNode targetSet) {
        targetSet.dataSet.add(dataId);
    }

    private boolean isDummyHead(DoublyLinkedNode node) {
        return node.count == -1;
    }

    private class DoublyLinkedNode {
        public DoublyLinkedNode next;
        public DoublyLinkedNode prev;
        public ConcurrentHashSet<String> dataSet;
        public int count;

        public DoublyLinkedNode(DoublyLinkedNode next, DoublyLinkedNode prev, ConcurrentHashSet<String> dataSet, int count) {
            this.next = next;
            this.prev = prev;
            this.dataSet = dataSet;
            this.count = count;
        }
    }
}

