/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.grpc.auto.BiRequestStreamGrpc;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.grpc.auto.RequestGrpc;
import com.alibaba.nacos.api.remote.request.ConnectionSetupRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.ServerCheckRequest;
import com.alibaba.nacos.api.remote.response.ErrorResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ServerCheckResponse;
import com.alibaba.nacos.common.packagescan.resource.Resource;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientStatus;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfig;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.remote.client.grpc.DefaultGrpcClientConfig;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClientConfig;
import com.alibaba.nacos.common.remote.client.grpc.GrpcConnection;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadFactoryBuilder;
import com.alibaba.nacos.common.utils.TlsTypeResolve;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Channel;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrpcClient
extends RpcClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcClient.class);
    private final GrpcClientConfig clientConfig;
    private ThreadPoolExecutor grpcExecutor;

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.GRPC;
    }

    public GrpcClient(String name) {
        this(DefaultGrpcClientConfig.newBuilder().setName(name).build());
    }

    public GrpcClient(Properties properties) {
        this(DefaultGrpcClientConfig.newBuilder().fromProperties(properties).build());
    }

    public GrpcClient(GrpcClientConfig clientConfig) {
        super(clientConfig);
        this.clientConfig = clientConfig;
    }

    public GrpcClient(GrpcClientConfig clientConfig, ServerListFactory serverListFactory) {
        super(clientConfig, serverListFactory);
        this.clientConfig = clientConfig;
    }

    public GrpcClient(String name, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels) {
        this(DefaultGrpcClientConfig.newBuilder().setName(name).setThreadPoolCoreSize(threadPoolCoreSize).setThreadPoolMaxSize(threadPoolMaxSize).setLabels(labels).build());
    }

    public GrpcClient(String name, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels, RpcClientTlsConfig tlsConfig) {
        this(DefaultGrpcClientConfig.newBuilder().setName(name).setThreadPoolCoreSize(threadPoolCoreSize).setTlsConfig(tlsConfig).setThreadPoolMaxSize(threadPoolMaxSize).setLabels(labels).build());
    }

    protected ThreadPoolExecutor createGrpcExecutor(String serverIp) {
        serverIp = serverIp.replaceAll("%", "-");
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(this.clientConfig.threadPoolCoreSize(), this.clientConfig.threadPoolMaxSize(), this.clientConfig.threadPoolKeepAlive(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.clientConfig.threadPoolQueueSize()), new ThreadFactoryBuilder().daemon(true).nameFormat("nacos-grpc-client-executor-" + serverIp + "-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    @Override
    public void shutdown() throws NacosException {
        super.shutdown();
        if (this.grpcExecutor != null) {
            LOGGER.info("Shutdown grpc executor " + this.grpcExecutor);
            this.grpcExecutor.shutdown();
        }
    }

    private RequestGrpc.RequestFutureStub createNewChannelStub(ManagedChannel managedChannelTemp) {
        return RequestGrpc.newFutureStub((Channel)managedChannelTemp);
    }

    private ManagedChannel createNewManagedChannel(String serverIp, int serverPort) {
        LOGGER.info("grpc client connection server:{} ip,serverPort:{},grpcTslConfig:{}", new Object[]{serverIp, serverPort, JacksonUtils.toJson(this.clientConfig.tlsConfig())});
        ManagedChannelBuilder managedChannelBuilder = this.buildChannel(serverIp, serverPort, this.buildSslContext()).executor((Executor)this.grpcExecutor).compressorRegistry(CompressorRegistry.getDefaultInstance()).decompressorRegistry(DecompressorRegistry.getDefaultInstance()).maxInboundMessageSize(this.clientConfig.maxInboundMessageSize()).keepAliveTime((long)this.clientConfig.channelKeepAlive(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.clientConfig.channelKeepAliveTimeout(), TimeUnit.MILLISECONDS);
        return managedChannelBuilder.build();
    }

    private void shuntDownChannel(ManagedChannel managedChannel) {
        if (managedChannel != null && !managedChannel.isShutdown()) {
            managedChannel.shutdownNow();
        }
    }

    private Response serverCheck(String ip, int port, RequestGrpc.RequestFutureStub requestBlockingStub) {
        try {
            if (requestBlockingStub == null) {
                return null;
            }
            ServerCheckRequest serverCheckRequest = new ServerCheckRequest();
            Payload grpcRequest = GrpcUtils.convert((Request)serverCheckRequest);
            ListenableFuture responseFuture = requestBlockingStub.request(grpcRequest);
            Payload response = (Payload)responseFuture.get(this.clientConfig.serverCheckTimeOut(), TimeUnit.MILLISECONDS);
            return (Response)GrpcUtils.parse(response);
        }
        catch (Exception e) {
            LoggerUtils.printIfErrorEnabled(LOGGER, "Server check fail, please check server {} ,port {} is available , error ={}", ip, port, e);
            return null;
        }
    }

    private StreamObserver<Payload> bindRequestStream(BiRequestStreamGrpc.BiRequestStreamStub streamStub, final GrpcConnection grpcConn) {
        return streamStub.requestBiStream((StreamObserver)new StreamObserver<Payload>(){

            public void onNext(Payload payload) {
                block5: {
                    LoggerUtils.printIfDebugEnabled(LOGGER, "[{}]Stream server request receive, original info: {}", grpcConn.getConnectionId(), payload.toString());
                    try {
                        Object parseBody = GrpcUtils.parse(payload);
                        Request request = (Request)parseBody;
                        if (request == null) break block5;
                        try {
                            Response response = GrpcClient.this.handleServerRequest(request);
                            if (response != null) {
                                response.setRequestId(request.getRequestId());
                                GrpcClient.this.sendResponse(response);
                                break block5;
                            }
                            LOGGER.warn("[{}]Fail to process server request, ackId->{}", (Object)grpcConn.getConnectionId(), (Object)request.getRequestId());
                        }
                        catch (Exception e) {
                            LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Handle server request exception: {}", grpcConn.getConnectionId(), payload.toString(), e.getMessage());
                            Response errResponse = ErrorResponse.build((int)-500, (String)"Handle server request error");
                            errResponse.setRequestId(request.getRequestId());
                            GrpcClient.this.sendResponse(errResponse);
                        }
                    }
                    catch (Exception e) {
                        LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Error to process server push response: {}", grpcConn.getConnectionId(), payload.getBody().getValue().toStringUtf8());
                    }
                }
            }

            public void onError(Throwable throwable) {
                boolean isRunning = GrpcClient.this.isRunning();
                boolean isAbandon = grpcConn.isAbandon();
                if (isRunning && !isAbandon) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Request stream error, switch server,error={}", grpcConn.getConnectionId(), throwable);
                    if (GrpcClient.this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                        GrpcClient.this.switchServerAsync();
                    }
                } else {
                    LoggerUtils.printIfWarnEnabled(LOGGER, "[{}]Ignore error event,isRunning:{},isAbandon={}", grpcConn.getConnectionId(), isRunning, isAbandon);
                }
            }

            public void onCompleted() {
                boolean isRunning = GrpcClient.this.isRunning();
                boolean isAbandon = grpcConn.isAbandon();
                if (isRunning && !isAbandon) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Request stream onCompleted, switch server", grpcConn.getConnectionId());
                    if (GrpcClient.this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                        GrpcClient.this.switchServerAsync();
                    }
                } else {
                    LoggerUtils.printIfInfoEnabled(LOGGER, "[{}]Ignore complete event,isRunning:{},isAbandon={}", grpcConn.getConnectionId(), isRunning, isAbandon);
                }
            }
        });
    }

    private void sendResponse(Response response) {
        try {
            ((GrpcConnection)this.currentConnection).sendResponse(response);
        }
        catch (Exception e) {
            LOGGER.error("[{}]Error to send ack response, ackId->{}", (Object)this.currentConnection.getConnectionId(), (Object)response.getRequestId());
        }
    }

    @Override
    public Connection connectToServer(RpcClient.ServerInfo serverInfo) {
        try {
            if (this.grpcExecutor == null) {
                this.grpcExecutor = this.createGrpcExecutor(serverInfo.getServerIp());
            }
            int port = serverInfo.getServerPort() + this.rpcPortOffset();
            ManagedChannel managedChannel = this.createNewManagedChannel(serverInfo.getServerIp(), port);
            RequestGrpc.RequestFutureStub newChannelStubTemp = this.createNewChannelStub(managedChannel);
            if (newChannelStubTemp != null) {
                Response response = this.serverCheck(serverInfo.getServerIp(), port, newChannelStubTemp);
                if (response == null || !(response instanceof ServerCheckResponse)) {
                    this.shuntDownChannel(managedChannel);
                    return null;
                }
                BiRequestStreamGrpc.BiRequestStreamStub biRequestStreamStub = BiRequestStreamGrpc.newStub((Channel)newChannelStubTemp.getChannel());
                GrpcConnection grpcConn = new GrpcConnection(serverInfo, this.grpcExecutor);
                grpcConn.setConnectionId(((ServerCheckResponse)response).getConnectionId());
                StreamObserver<Payload> payloadStreamObserver = this.bindRequestStream(biRequestStreamStub, grpcConn);
                grpcConn.setPayloadStreamObserver(payloadStreamObserver);
                grpcConn.setGrpcFutureServiceStub(newChannelStubTemp);
                grpcConn.setChannel(managedChannel);
                ConnectionSetupRequest conSetupRequest = new ConnectionSetupRequest();
                conSetupRequest.setClientVersion(VersionUtils.getFullClientVersion());
                conSetupRequest.setLabels(super.getLabels());
                conSetupRequest.setAbilities(this.clientAbilities);
                conSetupRequest.setTenant(super.getTenant());
                grpcConn.sendRequest((Request)conSetupRequest);
                Thread.sleep(100L);
                return grpcConn;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("[{}]Fail to connect to server!,error={}", (Object)this.getName(), (Object)e);
            return null;
        }
    }

    private ManagedChannelBuilder buildChannel(String serverIp, int port, Optional<SslContext> sslContext) {
        if (sslContext.isPresent()) {
            return NettyChannelBuilder.forAddress((String)serverIp, (int)port).negotiationType(NegotiationType.TLS).sslContext((SslContext)sslContext.get());
        }
        return ManagedChannelBuilder.forAddress((String)serverIp, (int)port).usePlaintext();
    }

    private Optional<SslContext> buildSslContext() {
        RpcClientTlsConfig tlsConfig = this.clientConfig.tlsConfig();
        if (!tlsConfig.getEnableTls().booleanValue()) {
            return Optional.absent();
        }
        try {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            if (StringUtils.isNotBlank(tlsConfig.getSslProvider())) {
                builder.sslProvider(TlsTypeResolve.getSslProvider(tlsConfig.getSslProvider()));
            }
            if (StringUtils.isNotBlank(tlsConfig.getProtocols())) {
                builder.protocols(tlsConfig.getProtocols().split(","));
            }
            if (StringUtils.isNotBlank(tlsConfig.getCiphers())) {
                builder.ciphers(Arrays.asList(tlsConfig.getCiphers().split(",")));
            }
            if (tlsConfig.getTrustAll().booleanValue()) {
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else {
                if (StringUtils.isBlank(tlsConfig.getTrustCollectionCertFile())) {
                    throw new IllegalArgumentException("trustCollectionCertFile must be not null");
                }
                Resource resource = this.resourceLoader.getResource(tlsConfig.getTrustCollectionCertFile());
                builder.trustManager(resource.getInputStream());
            }
            if (tlsConfig.getMutualAuthEnable().booleanValue()) {
                if (StringUtils.isBlank(tlsConfig.getCertChainFile()) || StringUtils.isBlank(tlsConfig.getCertPrivateKey())) {
                    throw new IllegalArgumentException("client certChainFile or certPrivateKey must be not null");
                }
                Resource certChainFile = this.resourceLoader.getResource(tlsConfig.getCertChainFile());
                Resource privateKey = this.resourceLoader.getResource(tlsConfig.getCertPrivateKey());
                builder.keyManager(certChainFile.getInputStream(), privateKey.getInputStream(), tlsConfig.getCertPrivateKeyPassword());
            }
            return Optional.of((Object)builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to build SslContext", e);
        }
    }
}

