/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.redo.data;

import java.util.Objects;

public abstract class RedoData<T> {
    private volatile boolean expectedRegistered = true;
    private volatile boolean registered;
    private volatile boolean unregistering;
    private T data;

    protected RedoData() {
    }

    public void setExpectedRegistered(boolean registered) {
        this.expectedRegistered = registered;
    }

    public boolean isExpectedRegistered() {
        return this.expectedRegistered;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isUnregistering() {
        return this.unregistering;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public void setUnregistering(boolean unregistering) {
        this.unregistering = unregistering;
    }

    public T get() {
        return this.data;
    }

    public void set(T data) {
        this.data = data;
    }

    public void registered() {
        this.registered = true;
        this.unregistering = false;
    }

    public void unregistered() {
        this.registered = false;
        this.unregistering = true;
    }

    public boolean isNeedRedo() {
        return !RedoType.NONE.equals((Object)this.getRedoType());
    }

    public RedoType getRedoType() {
        if (this.isRegistered() && !this.isUnregistering()) {
            return this.expectedRegistered ? RedoType.NONE : RedoType.UNREGISTER;
        }
        if (this.isRegistered() && this.isUnregistering()) {
            return RedoType.UNREGISTER;
        }
        if (!this.isRegistered() && !this.isUnregistering()) {
            return RedoType.REGISTER;
        }
        return this.expectedRegistered ? RedoType.REGISTER : RedoType.REMOVE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedoData redoData = (RedoData)o;
        return this.registered == redoData.registered && this.unregistering == redoData.unregistering && Objects.equals(this.data, redoData.data);
    }

    public int hashCode() {
        return Objects.hash(this.registered, this.unregistering, this.data);
    }

    public static enum RedoType {
        REGISTER,
        UNREGISTER,
        NONE,
        REMOVE;

    }
}

