/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.cache;

import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.ai.event.McpServerChangedEvent;
import com.alibaba.nacos.client.ai.remote.AiGrpcClient;
import com.alibaba.nacos.client.ai.utils.CacheKeyUtils;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosMcpServerCacheHolder
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosMcpServerCacheHolder.class);
    private final AiGrpcClient aiGrpcClient;
    private final Map<String, McpServerDetailInfo> mcpServerCache;
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService updaterExecutor;
    private final long updateIntervalMillis;
    private final Map<String, McpServerUpdater> updateTaskMap;

    public NacosMcpServerCacheHolder(AiGrpcClient aiGrpcClient, NacosClientProperties properties) {
        this.aiGrpcClient = aiGrpcClient;
        this.mcpServerCache = new ConcurrentHashMap<String, McpServerDetailInfo>(4);
        this.updateTaskMap = new ConcurrentHashMap<String, McpServerUpdater>(4);
        this.objectMapper = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.updaterExecutor = new ScheduledThreadPoolExecutor(1, new NameThreadFactory("com.alibaba.nacos.client.ai.mcp.server.updater"));
        this.updateIntervalMillis = properties.getLong("nacosAiMcpServerCacheUpdateInterval", Long.valueOf(10000L));
    }

    public McpServerDetailInfo getMcpServer(String mcpName, String version) {
        String key = CacheKeyUtils.buildMcpServerKey(mcpName, version);
        return this.mcpServerCache.get(key);
    }

    public void processMcpServerDetailInfo(McpServerDetailInfo detailInfo) {
        String mcpName = detailInfo.getName();
        String version = detailInfo.getVersionDetail().getVersion();
        Boolean isLatest = detailInfo.getVersionDetail().getIs_latest();
        String key = CacheKeyUtils.buildMcpServerKey(mcpName, version);
        McpServerDetailInfo oldMcpServer = this.mcpServerCache.get(key);
        this.mcpServerCache.put(key, detailInfo);
        if (null != isLatest && isLatest.booleanValue()) {
            String latestVersionKey = CacheKeyUtils.buildMcpServerKey(mcpName, null);
            this.mcpServerCache.put(latestVersionKey, detailInfo);
        }
        if (this.isMcpServerChanged(oldMcpServer, detailInfo)) {
            LOGGER.info("mcp server {} changed.", (Object)detailInfo.getName());
            NotifyCenter.publishEvent(new McpServerChangedEvent(detailInfo));
        }
    }

    public void addMcpServerUpdateTask(String mcpName, String version) {
        String mcpServerKey = CacheKeyUtils.buildMcpServerKey(mcpName, version);
        this.updateTaskMap.computeIfAbsent(mcpServerKey, s -> {
            McpServerUpdater updateTask = new McpServerUpdater(mcpName, version);
            this.updaterExecutor.schedule(updateTask, this.updateIntervalMillis, TimeUnit.MILLISECONDS);
            return updateTask;
        });
    }

    public void removeMcpServerUpdateTask(String mcpName, String version) {
        String mcpServerKey = CacheKeyUtils.buildMcpServerKey(mcpName, version);
        McpServerUpdater updateTask = this.updateTaskMap.remove(mcpServerKey);
        if (null != updateTask) {
            updateTask.cancel();
        }
    }

    private boolean isMcpServerChanged(McpServerDetailInfo oldMcpServer, McpServerDetailInfo detailInfo) {
        try {
            String newJson = this.objectMapper.writeValueAsString((Object)detailInfo);
            if (null == oldMcpServer) {
                LOGGER.info("init new mcp service: {} -> {}", (Object)detailInfo.getName(), (Object)newJson);
                return true;
            }
            String oldJson = this.objectMapper.writeValueAsString((Object)oldMcpServer);
            if (!StringUtils.equals(oldJson, newJson)) {
                LOGGER.info("mcp service changed: {} -> {}", (Object)oldJson, (Object)newJson);
                return true;
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Compare mcp server info failed: ", (Throwable)e);
        }
        return false;
    }

    @Override
    public void shutdown() throws NacosException {
        this.updaterExecutor.shutdownNow();
    }

    private class McpServerUpdater
    implements Runnable {
        private final String mcpName;
        private final String version;
        private final AtomicBoolean cancel;

        public McpServerUpdater(String mcpName, String version) {
            this.mcpName = mcpName;
            this.version = version;
            this.cancel = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            if (this.cancel.get()) {
                return;
            }
            try {
                McpServerDetailInfo detailInfo = NacosMcpServerCacheHolder.this.aiGrpcClient.queryMcpServer(this.mcpName, this.version);
                NacosMcpServerCacheHolder.this.processMcpServerDetailInfo(detailInfo);
            }
            catch (Exception e) {
                NacosException nacosException;
                if (e instanceof NacosException && (nacosException = (NacosException)e).getErrCode() == 404) {
                    return;
                }
                LOGGER.warn("Mcp server updater execute query failed", (Throwable)e);
            }
            finally {
                if (!this.cancel.get()) {
                    NacosMcpServerCacheHolder.this.updaterExecutor.schedule(this, NacosMcpServerCacheHolder.this.updateIntervalMillis, TimeUnit.MILLISECONDS);
                }
            }
        }

        public void cancel() {
            this.cancel.set(true);
        }
    }
}

