/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.event;

import com.alibaba.nacos.api.ai.listener.AbstractNacosMcpServerListener;
import com.alibaba.nacos.api.ai.listener.NacosMcpServerEvent;
import com.alibaba.nacos.client.selector.ListenerInvoker;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpServerListenerInvoker
implements ListenerInvoker<NacosMcpServerEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpServerListenerInvoker.class);
    private final AbstractNacosMcpServerListener listener;
    private final AtomicBoolean invoked = new AtomicBoolean(false);

    public McpServerListenerInvoker(AbstractNacosMcpServerListener listener) {
        this.listener = listener;
    }

    @Override
    public void invoke(NacosMcpServerEvent event) {
        this.invoked.set(true);
        this.logInvoke(event);
        if (this.listener.getExecutor() != null) {
            this.listener.getExecutor().execute(() -> this.listener.onEvent(event));
        } else {
            this.listener.onEvent(event);
        }
    }

    private void logInvoke(NacosMcpServerEvent event) {
        LOGGER.info("Invoke event namespaceId: {}, mcpId: {}, mcpName: {} to Listener: {}", new Object[]{event.getNamespaceId(), event.getMcpId(), event.getMcpName(), this.listener.toString()});
    }

    @Override
    public boolean isInvoked() {
        return this.invoked.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        McpServerListenerInvoker that = (McpServerListenerInvoker)o;
        return Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hashCode(this.listener);
    }
}

