/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.event;

import com.alibaba.nacos.api.ai.listener.NacosMcpServerEvent;
import com.alibaba.nacos.client.ai.event.McpServerChangedEvent;
import com.alibaba.nacos.client.ai.event.McpServerListenerInvoker;
import com.alibaba.nacos.client.ai.utils.McpServerUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class McpServerChangeNotifier
extends Subscriber<McpServerChangedEvent> {
    private final Map<String, Set<McpServerListenerInvoker>> mcpServerListenerInvokers = new ConcurrentHashMap<String, Set<McpServerListenerInvoker>>(2);

    @Override
    public void onEvent(McpServerChangedEvent event) {
        String mcpServerKey = McpServerUtils.buildMcpServerKey(event.getMcpName(), event.getVersion());
        if (!this.isSubscribed(mcpServerKey)) {
            return;
        }
        NacosMcpServerEvent notifiedEvent = new NacosMcpServerEvent(event.getMcpServer());
        for (McpServerListenerInvoker each : this.mcpServerListenerInvokers.get(mcpServerKey)) {
            each.invoke(notifiedEvent);
        }
    }

    @Override
    public Class<? extends Event> subscribeType() {
        return McpServerChangedEvent.class;
    }

    public void registerListener(String mcpName, String version, McpServerListenerInvoker listenerInvoker) {
        if (listenerInvoker == null) {
            return;
        }
        String mcpServerKey = McpServerUtils.buildMcpServerKey(mcpName, version);
        this.mcpServerListenerInvokers.compute(mcpServerKey, (key, mcpServerListenerInvokers) -> {
            if (null == mcpServerListenerInvokers) {
                mcpServerListenerInvokers = new ConcurrentHashSet<McpServerListenerInvoker>();
            }
            mcpServerListenerInvokers.add(listenerInvoker);
            return mcpServerListenerInvokers;
        });
    }

    public void deregisterListener(String mcpName, String version, McpServerListenerInvoker listenerInvoker) {
        if (listenerInvoker == null) {
            return;
        }
        String mcpServerKey = McpServerUtils.buildMcpServerKey(mcpName, version);
        this.mcpServerListenerInvokers.compute(mcpServerKey, (key, mcpServerListenerInvokers) -> {
            if (null == mcpServerListenerInvokers) {
                return null;
            }
            mcpServerListenerInvokers.remove(listenerInvoker);
            return mcpServerListenerInvokers.isEmpty() ? null : mcpServerListenerInvokers;
        });
    }

    public boolean isSubscribed(String mcpName) {
        return CollectionUtils.isNotEmpty(this.mcpServerListenerInvokers.get(mcpName));
    }
}

