/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.provider;

import com.alibaba.nacos.client.aliyun.auth.ExtensionAuthPropertyKey;
import com.alibaba.nacos.client.aliyun.provider.KmsCredentialsProvider;
import com.alibaba.nacos.common.utils.StringUtils;
import com.aliyun.credentials.models.Config;
import java.util.Properties;

public class StsTokenKmsCredentialsProvider
implements KmsCredentialsProvider {
    private String stsAccessKey;
    private String stsSecretKey;
    private String securityToken;

    @Override
    public boolean matchProvider(Properties properties) {
        this.stsAccessKey = properties.getProperty("kmsExtensionAccessKey", System.getProperty("kmsExtensionAccessKey", System.getenv("kmsExtensionAccessKey")));
        if (StringUtils.isBlank((CharSequence)this.stsAccessKey)) {
            this.stsAccessKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_ID);
        }
        this.stsSecretKey = properties.getProperty("kmsExtensionSecretKey", System.getProperty("kmsExtensionSecretKey", System.getenv("kmsExtensionSecretKey")));
        if (StringUtils.isBlank((CharSequence)this.stsSecretKey)) {
            this.stsSecretKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_SECRET);
        }
        this.securityToken = properties.getProperty("kmsSecurityToken", System.getProperty("kmsSecurityToken", System.getenv("kmsSecurityToken")));
        if (StringUtils.isBlank((CharSequence)this.securityToken)) {
            this.securityToken = this.getNacosProperties(properties, ExtensionAuthPropertyKey.SECURITY_TOKEN);
        }
        return StringUtils.isNotBlank((String)this.stsAccessKey) && StringUtils.isNotBlank((String)this.stsSecretKey) && StringUtils.isNotBlank((String)this.securityToken);
    }

    @Override
    public Config generateCredentialsConfig(Properties properties) {
        Config credentialConfig = new Config();
        credentialConfig.setType("sts");
        credentialConfig.setAccessKeyId(this.stsAccessKey);
        credentialConfig.setAccessKeySecret(this.stsSecretKey);
        credentialConfig.setSecurityToken(this.securityToken);
        return credentialConfig;
    }
}

