/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.provider;

import com.alibaba.nacos.client.aliyun.auth.ExtensionAuthPropertyKey;
import com.alibaba.nacos.client.aliyun.provider.KmsCredentialsProvider;
import com.alibaba.nacos.common.utils.StringUtils;
import com.aliyun.credentials.models.Config;
import java.util.Properties;

public class OidcRoleArnKmsCredentialsProvider
implements KmsCredentialsProvider {
    private String roleArn;
    private String roleSessionName;
    private String oidcProviderArn;
    private String oidcTokenFilePath;

    @Override
    public boolean matchProvider(Properties properties) {
        this.roleArn = properties.getProperty("kmsRoleArn", System.getProperty("kmsRoleArn", System.getenv("kmsRoleArn")));
        if (StringUtils.isBlank((CharSequence)this.roleArn)) {
            this.roleArn = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_ARN);
        }
        this.roleSessionName = properties.getProperty("kmsRoleSessionName", System.getProperty("kmsRoleSessionName", System.getenv("kmsRoleSessionName")));
        if (StringUtils.isBlank((CharSequence)this.roleSessionName)) {
            this.roleSessionName = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_SESSION_NAME);
        }
        this.oidcProviderArn = properties.getProperty("kmsOidcProviderArn", System.getProperty("kmsOidcProviderArn", System.getenv("kmsOidcProviderArn")));
        if (StringUtils.isBlank((CharSequence)this.oidcProviderArn)) {
            this.oidcProviderArn = this.getNacosProperties(properties, ExtensionAuthPropertyKey.OIDC_PROVIDER_ARN);
        }
        this.oidcTokenFilePath = properties.getProperty("kmsOidcTokenFilePath", System.getProperty("kmsOidcTokenFilePath", System.getenv("kmsOidcTokenFilePath")));
        if (StringUtils.isBlank((CharSequence)this.oidcTokenFilePath)) {
            this.oidcTokenFilePath = this.getNacosProperties(properties, ExtensionAuthPropertyKey.OIDC_TOKEN_FILE_PATH);
        }
        return StringUtils.isNotBlank((String)this.roleArn) && StringUtils.isNotBlank((String)this.roleSessionName) && StringUtils.isNotBlank((String)this.oidcProviderArn) && StringUtils.isNotBlank((String)this.oidcTokenFilePath);
    }

    @Override
    public Config generateCredentialsConfig(Properties properties) {
        String roleSessionExpiration;
        Config credentialsConfig = new Config();
        credentialsConfig.setType("oidc_role_arn");
        credentialsConfig.setRoleArn(this.roleArn);
        credentialsConfig.setRoleSessionName(this.roleSessionName);
        credentialsConfig.setOidcProviderArn(this.oidcProviderArn);
        credentialsConfig.setOidcTokenFilePath(this.oidcTokenFilePath);
        String policy = properties.getProperty("kmsPolicy", System.getProperty("kmsPolicy", System.getenv("kmsPolicy")));
        if (StringUtils.isBlank((CharSequence)policy)) {
            policy = this.getNacosProperties(properties, ExtensionAuthPropertyKey.POLICY);
        }
        if (StringUtils.isNotBlank((String)policy)) {
            credentialsConfig.setPolicy(policy);
        }
        if (StringUtils.isBlank((CharSequence)(roleSessionExpiration = properties.getProperty("kmsRoleSessionExpiration", System.getProperty("kmsRoleSessionExpiration", System.getenv("kmsRoleSessionExpiration")))))) {
            roleSessionExpiration = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_SESSION_EXPIRATION);
        }
        if (StringUtils.isNotBlank((String)roleSessionExpiration)) {
            credentialsConfig.setRoleSessionExpiration(Integer.valueOf(Integer.parseInt(roleSessionExpiration)));
        }
        return credentialsConfig;
    }
}

