/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth.provider;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.auth.ExtensionAuthPropertyKey;
import com.alibaba.nacos.client.aliyun.auth.ExtensionRamContext;
import com.alibaba.nacos.client.aliyun.auth.provider.ExtensionCredentialsProvider;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.aliyuncs.kms.secretsmanager.client.SecretCacheClient;
import com.aliyuncs.kms.secretsmanager.client.SecretCacheClientBuilder;
import com.aliyuncs.kms.secretsmanager.client.exception.CacheSecretException;
import com.aliyuncs.kms.secretsmanager.client.model.SecretInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Properties;

public class AutoRotateCredentialsProvider
implements ExtensionCredentialsProvider {
    private SecretCacheClient client;
    private String secretName;
    private String signatureRegionId;

    @Override
    public boolean matchProvider(Properties properties) {
        return !StringUtils.isEmpty((CharSequence)this.getNacosProperties(properties, ExtensionAuthPropertyKey.SECRET_NAME));
    }

    @Override
    public void init(Properties properties) {
        this.secretName = this.getNacosProperties(properties, ExtensionAuthPropertyKey.SECRET_NAME);
        this.signatureRegionId = this.getSignatureRegionId(properties);
        this.buildSecretClient();
    }

    private synchronized void buildSecretClient() {
        try {
            if (null == this.client) {
                this.client = SecretCacheClientBuilder.newClient();
            }
        }
        catch (Exception e) {
            throw new NacosRuntimeException(23000, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ExtensionRamContext getCredentialsForNacosClient() {
        ExtensionRamContext result = new ExtensionRamContext();
        result.setEphemeralAccessKeyId(false);
        if (null == this.client) {
            return result;
        }
        try {
            SecretInfo secretInfo = this.client.getSecretInfo(this.secretName);
            JsonNode jsonNode = JacksonUtils.toObj((String)secretInfo.getSecretValue());
            result.setAccessKey(jsonNode.get("AccessKeyId").asText());
            result.setSecretKey(jsonNode.get("AccessKeySecret").asText());
            result.setExtensionSignatureRegionId(this.signatureRegionId);
        }
        catch (CacheSecretException e) {
            return result;
        }
        return result;
    }

    public void shutdown() throws NacosException {
    }
}

