/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth.injector;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.aliyun.auth.ExtensionRamContext;
import com.alibaba.nacos.client.aliyun.auth.injector.AbstractExtensionResourceInjector;
import com.alibaba.nacos.client.auth.ram.utils.SignUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class NamingExtensionResourceInjector
extends AbstractExtensionResourceInjector {
    private static final String SIGNATURE_FILED = "signature";
    private static final String DATA_FILED = "data";
    private static final String AK_FILED = "ak";

    @Override
    protected String getAccessKeyHeaderKey() {
        return AK_FILED;
    }

    @Override
    protected Map<String, String> calculateSignature(RequestResource resource, String actualSecretKey, ExtensionRamContext ramContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String signData = this.getSignData(this.getGroupedServiceName(resource));
            String signature = SignUtil.sign((String)signData, (String)actualSecretKey);
            result.put(SIGNATURE_FILED, signature);
            result.put(DATA_FILED, signData);
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.warn("Calculate auth signature for naming failed.", (Throwable)e);
        }
        return result;
    }

    private String getGroupedServiceName(RequestResource resource) {
        if (resource.getResource().contains("@@") || StringUtils.isBlank((CharSequence)resource.getGroup())) {
            return resource.getResource();
        }
        return NamingUtils.getGroupedNameOptional((String)resource.getResource(), (String)resource.getGroup());
    }

    private String getSignData(String serviceName) {
        return StringUtils.isNotEmpty((String)serviceName) ? System.currentTimeMillis() + "@@" + serviceName : String.valueOf(System.currentTimeMillis());
    }
}

