/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth.injector;

import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.auth.ExtensionRamContext;
import com.alibaba.nacos.client.auth.ram.RamContext;
import com.alibaba.nacos.client.auth.ram.injector.AbstractResourceInjector;
import com.alibaba.nacos.client.auth.ram.utils.CalculateV4SigningKeyUtil;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import java.util.Map;

public abstract class AbstractExtensionResourceInjector
extends AbstractResourceInjector {
    private boolean supportV4signature;

    protected AbstractExtensionResourceInjector() {
        try {
            Class.forName("com.alibaba.nacos.client.auth.ram.utils.CalculateV4SigningKeyUtil");
            this.supportV4signature = true;
        }
        catch (ClassNotFoundException e) {
            this.supportV4signature = false;
        }
    }

    public void doInject(RequestResource resource, RamContext context, LoginIdentityContext result) {
        ExtensionRamContext ramContext = (ExtensionRamContext)context;
        result.setParameter(this.getAccessKeyHeaderKey(), ramContext.getAccessKey());
        if (ramContext.isEphemeralAccessKeyId()) {
            result.setParameter("Spas-SecurityToken", ramContext.getSecurityToken());
        }
        String secretKey = this.trySignatureWithV4(ramContext, result);
        Map<String, String> signatures = this.calculateSignature(resource, secretKey, ramContext);
        result.setParameters(signatures);
    }

    protected String trySignatureWithV4(ExtensionRamContext context, LoginIdentityContext result) {
        if (!this.supportV4signature || StringUtils.isEmpty((CharSequence)context.getExtensionSignatureRegionId())) {
            return context.getSecretKey();
        }
        result.setParameter("signatureVersion", "v4");
        return CalculateV4SigningKeyUtil.finalSigningKeyStringWithDefaultInfo((String)context.getSecretKey(), (String)context.getExtensionSignatureRegionId());
    }

    protected abstract String getAccessKeyHeaderKey();

    protected abstract Map<String, String> calculateSignature(RequestResource var1, String var2, ExtensionRamContext var3);
}

