/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import com.alibaba.nacos.api.config.filter.IConfigRequest;
import com.alibaba.nacos.api.config.filter.IConfigResponse;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.AesUtils;
import com.alibaba.nacos.client.aliyun.AliyunConfigFilter;
import com.alibaba.nacos.client.aliyun.AliyunConst;
import com.alibaba.nacos.client.aliyun.GroupKeyUtils;
import com.alibaba.nacos.client.aliyun.KmsLocalCache;
import com.alibaba.nacos.client.aliyun.KmsUtils;
import com.alibaba.nacos.client.aliyun.MD5Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KmsEncryptor
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunConfigFilter.class);
    private KmsLocalCache kmsLocalCache;
    public static final int defaultRetryTimes = 3;
    public static final int defaultRetryIntervalMilliseconds = 200;
    public static final int defaultTimeoutMilliseconds = 3000;
    public boolean isUseLocalCache;

    public KmsEncryptor(Properties properties) {
        this.isUseLocalCache = KmsUtils.parsePropertyValue(properties, "nacos.config.encryption.kms.local.cache.switch", true);
        if (this.isUseLocalCache()) {
            LOGGER.info("using kms encryption local cache.");
            this.kmsLocalCache = new KmsLocalCache(properties);
        }
    }

    public String encrypt(IConfigRequest configRequest) throws Exception {
        this.checkIfKmsClientIsReady();
        this.checkKeyId();
        this.protectKeyId();
        String dataId = (String)configRequest.getParameter("dataId");
        String group = (String)configRequest.getParameter("group");
        String plainContent = (String)configRequest.getParameter("content");
        String plainDataKey = null;
        String encryptedDataKey = null;
        String result = null;
        String blankResultErrorMsg = "encrypt from kms failed.";
        try {
            if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
                String keySpec = KmsUtils.getKeySpecByDataIdPrefix(dataId);
                DataKey dataKey = this.generateDataKey(keySpec);
                plainDataKey = dataKey.getPlainDataKey();
                this.throwExceptionIfStringBlankWithErrorKey(plainDataKey, GroupKeyUtils.getGroupKey2(dataId, group), "generateDataKeyResponse.getPlaintext()", "plainDataKey");
                encryptedDataKey = dataKey.getEncryptedDataKey();
                this.throwExceptionIfStringBlankWithErrorKey(encryptedDataKey, GroupKeyUtils.getGroupKey2(dataId, group), "generateDataKeyResponse.getCiphertextBlob()", "encryptedDataKey");
                configRequest.putParameter("encryptedDataKey", (Object)encryptedDataKey);
                result = AesUtils.encrypt(plainContent, plainDataKey, AliyunConst.ENCODE_UTF8);
            } else if (dataId.startsWith("cipher-")) {
                result = this.encrypt(plainContent);
            }
        }
        catch (Exception e) {
            LOGGER.error("encrypt config:[{}] failed by using kms service: {}.", new Object[]{GroupKeyUtils.getGroupKey2(dataId, group), e.getMessage(), e});
            throw e;
        }
        this.throwExceptionIfStringBlankWithErrorKey(result, GroupKeyUtils.getGroupKey2(dataId, group), "encrypt failed", blankResultErrorMsg);
        this.updateLocalCacheItem(group, dataId, encryptedDataKey, result, plainDataKey, plainContent);
        return result;
    }

    public abstract String encrypt(String var1) throws Exception;

    public String decrypt(IConfigResponse configResponse) throws Exception {
        this.checkIfKmsClientIsReady();
        String dataId = (String)configResponse.getParameter("dataId");
        String group = (String)configResponse.getParameter("group");
        String encryptedContent = (String)configResponse.getParameter("content");
        String encryptedDataKey = (String)configResponse.getParameter("encryptedDataKey");
        String plainDataKey = null;
        String result = null;
        Exception requestKmsException = null;
        String blankResultErrorMsg = "decrypt from kms failed.";
        boolean isUsedCache = true;
        try {
            if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
                this.throwExceptionIfStringBlankWithErrorKey(encryptedDataKey, GroupKeyUtils.getGroupKey2(dataId, group), "decrypt failed", "response.getParameter(ENCRYPTED_DATA_KEY)");
                plainDataKey = this.decrypt(encryptedDataKey);
                result = AesUtils.decrypt(encryptedContent, plainDataKey, AliyunConst.ENCODE_UTF8);
            } else if (dataId.startsWith("cipher-")) {
                result = this.decrypt(encryptedContent);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("decrypt config:[{}] failed by using kms service: {}.", new Object[]{GroupKeyUtils.getGroupKey2(dataId, group), e.getMessage(), e});
            requestKmsException = e;
        }
        if (requestKmsException != null || StringUtils.isBlank((CharSequence)result)) {
            LOGGER.warn("decrypt config [{}] failed with exception or empty result by using kms service. try to use local cache.", (Object)GroupKeyUtils.getGroupKey2(dataId, group));
            result = this.getDecryptedContentByUsingLocalCache(group, dataId, encryptedDataKey, encryptedContent);
            if (requestKmsException != null && StringUtils.isBlank((CharSequence)result)) {
                throw requestKmsException;
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                blankResultErrorMsg = blankResultErrorMsg + "and no kms decryption local cache.";
            }
        } else {
            isUsedCache = false;
        }
        this.throwExceptionIfStringBlankWithErrorKey(result, GroupKeyUtils.getGroupKey2(dataId, group), "decrypt failed", blankResultErrorMsg);
        if (!isUsedCache) {
            this.updateLocalCacheItem(group, dataId, encryptedDataKey, encryptedContent, plainDataKey, result);
        }
        return result;
    }

    public abstract String decrypt(String var1) throws Exception;

    public abstract void protectKeyId();

    public abstract DataKey generateDataKey(String var1) throws Exception;

    public abstract void checkIfKmsClientIsReady() throws Exception;

    public abstract void checkKeyId() throws Exception;

    public void updateLocalCacheItem(String group, String dataId, String encryptedDataKey, String encryptedContent, String plainDataKey, String plainContent) {
        if (!this.isLocalCacheAvailable()) {
            return;
        }
        if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
            this.getKmsLocalCache().put(GroupKeyUtils.getGroupKey2(dataId, group), new KmsLocalCache.LocalCacheItem(encryptedDataKey, encryptedContent, plainDataKey));
        } else if (dataId.startsWith("cipher-")) {
            this.getKmsLocalCache().put(GroupKeyUtils.getGroupKey2(dataId, group), new KmsLocalCache.LocalCacheItem(encryptedContent, plainContent));
        }
    }

    public boolean isUseLocalCache() {
        return this.isUseLocalCache;
    }

    public KmsLocalCache getKmsLocalCache() {
        return this.kmsLocalCache;
    }

    public boolean isLocalCacheAvailable() {
        return this.isUseLocalCache() && this.getKmsLocalCache() != null;
    }

    public String getDecryptedContentByUsingLocalCache(String group, String dataId, String encryptedDataKey, String encryptedContent) throws Exception {
        KmsLocalCache.LocalCacheItem localCacheItem = this.getLocalCacheItem(group, dataId, encryptedDataKey, encryptedContent);
        if (localCacheItem != null) {
            if (!StringUtils.isBlank((CharSequence)localCacheItem.getPlainDataKey())) {
                return AesUtils.decrypt(encryptedContent, localCacheItem.getPlainDataKey(), AliyunConst.ENCODE_UTF8);
            }
            if (!StringUtils.isBlank((CharSequence)localCacheItem.getPlainContent())) {
                return localCacheItem.getPlainContent();
            }
        }
        return null;
    }

    public KmsLocalCache.LocalCacheItem getLocalCacheItem(String group, String dataId, String encryptDataKey, String encryptedContent) {
        if (!this.isLocalCacheAvailable()) {
            return null;
        }
        KmsLocalCache.LocalCacheItem localCacheItem = this.getKmsLocalCache().get(GroupKeyUtils.getGroupKey2(dataId, group));
        if (localCacheItem == null) {
            return null;
        }
        if (!this.checkIfKmsCacheItemValidByDecrypt(localCacheItem, dataId, encryptDataKey, encryptedContent)) {
            return null;
        }
        return localCacheItem;
    }

    public KmsLocalCache.LocalCacheItem getLocalCacheItem(String group, String dataId, String plainText) {
        if (!this.isLocalCacheAvailable()) {
            return null;
        }
        KmsLocalCache.LocalCacheItem localCacheItem = this.getKmsLocalCache().get(GroupKeyUtils.getGroupKey2(dataId, group));
        if (localCacheItem == null) {
            return null;
        }
        if (this.checkIfKmsCacheItemValidByEncrypt(localCacheItem, dataId, plainText)) {
            return null;
        }
        return localCacheItem;
    }

    public void locallyRunWithRetryTimesAndTimeout(Supplier<Boolean> runnable, int retryTimes, long timeout) throws Exception {
        int locallyRetryTimes = 0;
        Exception localException = null;
        long beginTime = System.currentTimeMillis();
        while (locallyRetryTimes++ < retryTimes && System.currentTimeMillis() < beginTime + timeout) {
            try {
                if (runnable.get().booleanValue()) {
                    break;
                }
            }
            catch (Exception e) {
                localException = e;
            }
            Thread.sleep(200L);
        }
        if (localException != null) {
            throw localException;
        }
    }

    private boolean checkIfKmsCacheItemValidByEncrypt(KmsLocalCache.LocalCacheItem localCacheItem, String dataId, String plainContent) {
        if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedDataKey()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainDataKey());
        }
        if (dataId.startsWith("cipher-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedContent()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainContent()) && localCacheItem.getPlainContent().equals(plainContent);
        }
        return false;
    }

    private boolean checkIfKmsCacheItemValidByDecrypt(KmsLocalCache.LocalCacheItem localCacheItem, String dataId, String encryptedDataKey, String encryptedContent) {
        String encryptedContentMd5 = MD5Utils.md5Hex(encryptedContent, AliyunConst.ENCODE_UTF8);
        if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedDataKey()) && !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedContentMD5()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainDataKey()) && StringUtils.equals((CharSequence)localCacheItem.getEncryptedDataKey(), (CharSequence)encryptedDataKey) && StringUtils.equals((CharSequence)localCacheItem.getEncryptedContentMD5(), (CharSequence)encryptedContentMd5);
        }
        if (dataId.startsWith("cipher-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedContentMD5()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainContent()) && StringUtils.equals((CharSequence)localCacheItem.getEncryptedContentMD5(), (CharSequence)encryptedContentMd5);
        }
        return false;
    }

    public String readFileToString(String filePath) {
        File file = this.getFileByPath(filePath);
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            byte[] fileContent = Files.readAllBytes(path);
            return new String(fileContent, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getFileByPath(String filePath) {
        String path;
        File file = new File(filePath);
        if (!(file.exists() || (file = new File((path = AliyunConfigFilter.class.getClassLoader().getResource("").getPath()) + filePath)).exists() || (file = new File(path = Paths.get(filePath, new String[0]).toAbsolutePath().toString())).exists())) {
            return null;
        }
        return file;
    }

    public void throwExceptionIfStringBlankWithErrorKey(String s, String groupKey, String errorMsg, String errorKey) throws Exception {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new RuntimeException(String.format("[config: %s] %s. %s is null or empty.", groupKey, errorMsg, errorKey) + "For more information, please check: " + "https://help.aliyun.com/zh/mse/user-guide/create-and-use-encrypted-configurations?spm=a2c4g.11186623.0.0.55587becdOW3jf");
        }
    }

    @Override
    public abstract void close() throws IOException;

    public static class DataKey {
        private String plainDataKey;
        private String encryptedDataKey;

        public String getPlainDataKey() {
            return this.plainDataKey;
        }

        public void setPlainDataKey(String plainDataKey) {
            this.plainDataKey = plainDataKey;
        }

        public String getEncryptedDataKey() {
            return this.encryptedDataKey;
        }

        public void setEncryptedDataKey(String encryptedDataKey) {
            this.encryptedDataKey = encryptedDataKey;
        }
    }
}

