/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import com.alibaba.nacos.api.config.filter.AbstractConfigFilter;
import com.alibaba.nacos.api.config.filter.IConfigFilterChain;
import com.alibaba.nacos.api.config.filter.IConfigRequest;
import com.alibaba.nacos.api.config.filter.IConfigResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.AliyunConst;
import com.alibaba.nacos.client.aliyun.ClientKeyKmsEncryptor;
import com.alibaba.nacos.client.aliyun.KmsEncryptor;
import com.alibaba.nacos.client.aliyun.RamKmsEncryptor;
import com.aliyuncs.exceptions.ClientException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunConfigFilter
extends AbstractConfigFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunConfigFilter.class);
    private KmsEncryptor kmsEncryptor;

    public void init(Properties properties) {
        LOGGER.info("init ConfigFilter: {}, for more information, please check: {}", (Object)this.getFilterName(), (Object)"https://help.aliyun.com/zh/mse/user-guide/create-and-use-encrypted-configurations?spm=a2c4g.11186623.0.0.55587becdOW3jf");
        String kmsClientKeyContent = properties.getProperty("kmsClientKeyContent", System.getProperty("kmsClientKeyContent", System.getenv("kmsClientKeyContent")));
        String kmsClientKeyFilePath = properties.getProperty("kmsClientKeyFilePath", System.getProperty("kmsClientKeyFilePath", System.getenv("kmsClientKeyFilePath")));
        if (!StringUtils.isBlank((CharSequence)kmsClientKeyContent) || !StringUtils.isBlank((CharSequence)kmsClientKeyFilePath)) {
            LOGGER.info("kmsClientKeyContent or kmsClientKeyFilePath is set up, using ClientKey to connect KMS.");
            this.kmsEncryptor = new ClientKeyKmsEncryptor(properties);
        } else {
            LOGGER.info("kmsClientKeyContent and kmsClientKeyFilePath are not set up, using Ram to connect KMS.");
            this.kmsEncryptor = new RamKmsEncryptor(properties);
        }
    }

    public void doFilter(IConfigRequest request, IConfigResponse response, IConfigFilterChain filterChain) throws NacosException {
        String dataId = null;
        String group = null;
        try {
            if (request != null) {
                dataId = (String)request.getParameter("dataId");
                group = (String)request.getParameter("group");
                if (dataId.startsWith("cipher-") && !StringUtils.isBlank((CharSequence)((String)request.getParameter("content")))) {
                    request.putParameter("content", (Object)this.kmsEncryptor.encrypt(request));
                }
                filterChain.doFilter(request, response);
            }
            if (response != null) {
                dataId = (String)response.getParameter("dataId");
                group = (String)response.getParameter("group");
                if (dataId.startsWith("cipher-") && !StringUtils.isBlank((CharSequence)((String)response.getParameter("content")))) {
                    response.putParameter("content", (Object)this.kmsEncryptor.decrypt(response));
                }
            }
        }
        catch (ClientException e) {
            String message = String.format("KMS message:[%s], error message:[%s], dataId: %s, groupId: %s", e.getMessage(), e.getErrMsg(), dataId, group);
            throw new NacosException(-500, AliyunConst.formatHelpMessage(message), (Throwable)e);
        }
        catch (Exception e) {
            throw new NacosException(400, AliyunConst.formatHelpMessage(e.getMessage()), (Throwable)e);
        }
    }

    public int getOrder() {
        return 1;
    }

    public String getFilterName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void close() throws IOException {
        this.kmsEncryptor.close();
    }
}

