/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.model.response;

import com.alibaba.nacos.api.utils.StringUtils;
import java.util.Map;

public class ServerLoaderMetric {
    private String address;
    private int sdkConCount;
    private int conCount;
    private String load;
    private String cpu;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getSdkConCount() {
        return this.sdkConCount;
    }

    public void setSdkConCount(int sdkConCount) {
        this.sdkConCount = sdkConCount;
    }

    public int getConCount() {
        return this.conCount;
    }

    public void setConCount(int conCount) {
        this.conCount = conCount;
    }

    public String getLoad() {
        return this.load;
    }

    public void setLoad(String load) {
        this.load = load;
    }

    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public static class Builder {
        private ServerLoaderMetric serverLoaderMetric = new ServerLoaderMetric();

        public static Builder newBuilder() {
            return new Builder();
        }

        public ServerLoaderMetric build() {
            return this.serverLoaderMetric;
        }

        public Builder withAddress(String address) {
            this.serverLoaderMetric.setAddress(address);
            return this;
        }

        public Builder convertFromMap(Map<String, String> metric) {
            this.serverLoaderMetric.setSdkConCount(this.convertInt(metric, "sdkConCount", 0));
            this.serverLoaderMetric.setConCount(this.convertInt(metric, "conCount", 0));
            this.serverLoaderMetric.setLoad(metric.get("load"));
            this.serverLoaderMetric.setCpu(metric.get("cpu"));
            return this;
        }

        private int convertInt(Map<String, String> metric, String key, int defaultValue) {
            String value = metric.get(key);
            if (!StringUtils.isBlank(value)) {
                return Integer.parseInt(value);
            }
            return defaultValue;
        }
    }
}

