/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionOf;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;

public class PGCreateTableParser
extends SQLCreateTableParser {
    public PGCreateTableParser(Lexer lexer) {
        super(new PGExprParser(lexer));
    }

    public PGCreateTableParser(String sql) {
        super(new PGExprParser(sql));
    }

    public PGCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        for (int i = 0; i < 2; ++i) {
            if (this.lexer.token() != Token.PARTITION) continue;
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (Token.OF.equals((Object)this.lexer.token())) {
                this.lexer.reset(mark);
                SQLPartitionOf partitionOf = this.parsePartitionOf();
                stmt.setPartitionOf(partitionOf);
                continue;
            }
            if (!Token.BY.equals((Object)this.lexer.token())) continue;
            this.lexer.reset(mark);
            SQLPartitionBy partitionClause = this.parsePartitionBy();
            stmt.setPartitionBy(partitionClause);
        }
        if (this.lexer.nextIf(Token.WITH)) {
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getTableOptions(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.nextIf(Token.TABLESPACE)) {
            stmt.setTablespace(this.exprParser.name());
        }
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        this.lexer.nextToken();
        this.accept(Token.BY);
        if (this.lexer.identifierEquals("LIST")) {
            this.lexer.nextToken();
            SQLPartitionByList list = new SQLPartitionByList();
            if (this.lexer.token() == Token.LPAREN) {
                list.setType(SQLPartitionByList.PartitionByListType.LIST_EXPRESSION);
                this.lexer.nextToken();
                while (true) {
                    list.addColumn(this.exprParser.expr());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else {
                this.acceptIdentifier("COLUMNS");
                list.setType(SQLPartitionByList.PartitionByListType.LIST_COLUMNS);
                this.accept(Token.LPAREN);
                while (true) {
                    list.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            return list;
        }
        if (this.lexer.identifierEquals("HASH") || this.lexer.identifierEquals("UNI_HASH")) {
            SQLPartitionByHash hash = new SQLPartitionByHash();
            if (this.lexer.identifierEquals("UNI_HASH")) {
                hash.setUnique(true);
            }
            this.lexer.nextToken();
            if (this.lexer.token() == Token.KEY) {
                this.lexer.nextToken();
                hash.setKey(true);
            }
            this.accept(Token.LPAREN);
            this.exprParser.exprList(hash.getColumns(), hash);
            this.accept(Token.RPAREN);
            return hash;
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            SQLPartitionByRange clause = this.partitionByRange();
            return clause;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLPartitionByRange partitionByRange() {
        SQLPartitionByRange clause = new SQLPartitionByRange();
        if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                clause.addColumn(this.exprParser.expr());
                this.accept(Token.RPAREN);
            } else {
                this.acceptIdentifier("COLUMNS");
                this.accept(Token.LPAREN);
                while (true) {
                    clause.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
        } else {
            SQLExpr expr = this.exprParser.expr();
            if (this.lexer.identifierEquals(FnvHash.Constants.STARTWITH)) {
                this.lexer.nextToken();
                SQLExpr start = this.exprParser.primary();
                this.acceptIdentifier("ENDWITH");
                SQLExpr end = this.exprParser.primary();
                expr = new SQLBetweenExpr(expr, start, end);
            }
            clause.setInterval(expr);
        }
        return clause;
    }

    @Override
    public SQLPartitionOf parsePartitionOf() {
        ArrayList<SQLExpr> sqlExprBetweens;
        this.lexer.nextToken();
        this.accept(Token.OF);
        SQLPartitionOf partitionOf = new SQLPartitionOf();
        SQLName tableNameTmp = this.exprParser.name();
        SQLExprTableSource sqlExprTableSource = new SQLExprTableSource(tableNameTmp);
        partitionOf.setParentTable(sqlExprTableSource);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.CONSTRAINT) {
                this.lexer.nextToken();
                SQLName constraintName = this.exprParser.name();
                partitionOf.setConstraintName(constraintName);
                this.accept(Token.CHECK);
                SQLExpr checkExpr = this.exprParser.expr();
                partitionOf.setCheckExpr(checkExpr);
            } else {
                SQLName columnName = this.exprParser.name();
                partitionOf.setColumnName(columnName);
                if (this.lexer.token() == Token.DEFAULT) {
                    this.accept(Token.DEFAULT);
                    SQLExpr defaultExpr = this.exprParser.primary();
                    partitionOf.setDefaultExpr(defaultExpr);
                }
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.DEFAULT) {
            this.accept(Token.DEFAULT);
            partitionOf.setUseDefault(true);
            return partitionOf;
        }
        this.accept(Token.FOR);
        this.accept(Token.VALUES);
        if (this.lexer.token() == Token.FROM) {
            this.accept(Token.FROM);
            this.accept(Token.LPAREN);
            sqlExprBetweens = new ArrayList<SQLExpr>();
            this.exprParser.exprList(sqlExprBetweens, partitionOf);
            partitionOf.setForValuesFrom(sqlExprBetweens);
            this.accept(Token.RPAREN);
            this.accept(Token.TO);
            this.accept(Token.LPAREN);
            ArrayList<SQLExpr> sqlExprAnds = new ArrayList<SQLExpr>();
            this.exprParser.exprList(sqlExprAnds, partitionOf);
            partitionOf.setForValuesTo(sqlExprAnds);
            this.accept(Token.RPAREN);
            return partitionOf;
        }
        if (this.lexer.token() == Token.IN) {
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            sqlExprBetweens = new ArrayList();
            this.exprParser.exprList(sqlExprBetweens, partitionOf);
            partitionOf.setForValuesIn(sqlExprBetweens);
            this.accept(Token.RPAREN);
            return partitionOf;
        }
        if (this.lexer.token() == Token.WITH) {
            this.accept(Token.WITH);
            this.accept(Token.LPAREN);
            this.acceptIdentifier("MODULUS");
            SQLExpr modulus = this.exprParser.primary();
            partitionOf.setForValuesModulus(modulus);
            this.accept(Token.COMMA);
            this.acceptIdentifier("REMAINDER");
            SQLIntegerExpr remainder = (SQLIntegerExpr)this.exprParser.primary();
            partitionOf.setForValuesRemainder(remainder);
            this.accept(Token.RPAREN);
            return partitionOf;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }
}

