/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.impala.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLPartitionSingle;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprHint;
import com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.druid.sql.dialect.impala.ast.ImpalaSQLPartitionValue;
import com.alibaba.druid.sql.dialect.impala.parser.ImpalaLexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class ImpalaExprParser
extends HiveExprParser {
    public ImpalaExprParser(Lexer lexer) {
        super(lexer);
    }

    public ImpalaExprParser(String sql, SQLParserFeature ... features) {
        super(new ImpalaLexer(sql, features));
        this.lexer.nextToken();
        this.dbType = DbType.impala;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.nextIfIdentifier("ENCODING")) {
            column.setEncode(this.expr());
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.COMPRESSION)) {
            column.setCompression(this.expr());
        }
        if (this.lexer.nextIfIdentifier("BLOCK_SIZE")) {
            column.setBlockSize(this.integerExpr());
        }
        return super.parseColumnRest(column);
    }

    @Override
    public SQLPartitionSingle parsePartition() {
        this.accept(Token.PARTITION);
        SQLPartitionSingle partitionDef = new SQLPartitionSingle();
        ImpalaSQLPartitionValue values = new ImpalaSQLPartitionValue();
        if (this.lexer.token() == Token.LITERAL_INT) {
            Number number = this.lexer.integerValue();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LT || this.lexer.token() == Token.LTEQ) {
                SQLPartitionValue.Operator leftOperator = this.getOperator(this.lexer.token());
                this.lexer.nextToken();
                values.setLeftOperator(leftOperator);
                values.setLeftBound(number.intValue());
                this.accept(Token.VALUES);
                if (this.lexer.token() == Token.LT || this.lexer.token() == Token.LTEQ) {
                    SQLPartitionValue.Operator rightOperator = this.getOperator(this.lexer.token());
                    this.lexer.nextToken();
                    values.setRightOperator(rightOperator);
                    values.setRightBound(this.lexer.integerValue().intValue());
                    this.accept(Token.LITERAL_INT);
                }
            }
        } else if (this.lexer.token() == Token.VALUES) {
            this.accept(Token.VALUES);
            values.setRightOperator(this.getOperator(this.lexer.token()));
            this.lexer.nextToken();
            values.setRightBound(this.lexer.integerValue().intValue());
            this.accept(Token.LITERAL_INT);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            this.acceptIdentifier("VALUE");
            this.accept(Token.EQ);
            values.setOperator(SQLPartitionValue.Operator.Equal);
            if (this.lexer.nextIf(Token.LPAREN)) {
                while (true) {
                    if (this.lexer.token() == Token.LITERAL_INT) {
                        values.addItem(new SQLIntegerExpr(this.lexer.integerValue().intValue()));
                        this.lexer.nextToken();
                    } else if (this.lexer.token() == Token.LITERAL_CHARS) {
                        values.addItem(new SQLCharExpr(this.lexer.stringVal()));
                        this.lexer.nextToken();
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else {
                SQLCharExpr charExpr = new SQLCharExpr(this.lexer.stringVal());
                values.addItem(charExpr);
                this.lexer.nextToken();
            }
        }
        partitionDef.setValues(values);
        SQLIdentifierExpr name = new SQLIdentifierExpr(values.constructPartitionName());
        partitionDef.setName(name);
        return partitionDef;
    }

    private SQLPartitionValue.Operator getOperator(Token token) {
        switch (token) {
            case LT: {
                return SQLPartitionValue.Operator.LessThan;
            }
            case LTEQ: {
                return SQLPartitionValue.Operator.LessThanEqual;
            }
        }
        return null;
    }

    @Override
    public void parseHints(List hints) {
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            hints.add(new SQLExprHint(this.expr()));
            this.accept(Token.RBRACKET);
        } else {
            super.parseHints(hints);
        }
    }
}

