/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.gaussdb.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLPartitionSingle;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.gaussdb.ast.GaussDbPartitionValue;
import com.alibaba.druid.sql.dialect.gaussdb.parser.GaussDbLexer;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class GaussDbExprParser
extends PGExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;

    public GaussDbExprParser(String sql, SQLParserFeature ... features) {
        this(new GaussDbLexer(sql, features));
        this.lexer.nextToken();
        this.dbType = DbType.gaussdb;
    }

    public GaussDbExprParser(GaussDbLexer lexer) {
        super(lexer);
        this.dbType = DbType.gaussdb;
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    public SQLPartitionSingle parsePartition() {
        this.accept(Token.PARTITION);
        SQLPartitionSingle partitionDef = new SQLPartitionSingle();
        SQLName name = this.name();
        partitionDef.setName(name);
        partitionDef.setValues(this.parsePartitionValues(false));
        return partitionDef;
    }

    public SQLPartitionSingle parseDistribution() {
        this.acceptIdentifier("SLICE");
        SQLPartitionSingle partitionDef = new SQLPartitionSingle();
        SQLName name = this.name();
        partitionDef.setName(name);
        partitionDef.setValues(this.parsePartitionValues(true));
        return partitionDef;
    }

    public SQLPartitionValue parsePartitionValues(boolean isDistribute) {
        GaussDbPartitionValue values = null;
        boolean isInterval = false;
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                values = new GaussDbPartitionValue(SQLPartitionValue.Operator.In);
                this.accept(Token.LPAREN);
                this.exprList(values.getItems(), values);
                this.accept(Token.RPAREN);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.LESS)) {
                this.lexer.nextToken();
                this.acceptIdentifier("THAN");
                values = new GaussDbPartitionValue(SQLPartitionValue.Operator.LessThan);
                if (this.lexer.identifierEquals(FnvHash.Constants.MAXVALUE)) {
                    SQLIdentifierExpr maxValue = new SQLIdentifierExpr(this.lexer.stringVal());
                    this.lexer.nextToken();
                    maxValue.setParent(values);
                    values.addItem(maxValue);
                } else {
                    this.accept(Token.LPAREN);
                    this.exprList(values.getItems(), values);
                    this.accept(Token.RPAREN);
                }
            } else if (this.lexer.token() == Token.LPAREN) {
                values = new GaussDbPartitionValue(SQLPartitionValue.Operator.List);
                this.lexer.nextToken();
                this.exprList(values.getItems(), values);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.TABLESPACE) {
                    this.lexer.nextToken();
                    values.setSpaceName(this.expr());
                } else if (this.lexer.identifierEquals(FnvHash.Constants.DATANODE)) {
                    this.lexer.nextToken();
                    values.setDataNodes(this.expr());
                }
            }
        } else if (this.lexer.token() == Token.START) {
            this.lexer.nextToken();
            values = new GaussDbPartitionValue(SQLPartitionValue.Operator.StartEndEvery);
            isInterval = true;
            values.setStart(this.expr());
        }
        if (this.lexer.token() == Token.END) {
            this.lexer.nextToken();
            if (!isInterval) {
                values = new GaussDbPartitionValue(SQLPartitionValue.Operator.StartEndEvery);
            }
            values.setEnd(this.expr());
            if (this.lexer.identifierEquals(FnvHash.Constants.EVERY)) {
                this.lexer.nextToken();
                if (!isInterval) {
                    values = new GaussDbPartitionValue(SQLPartitionValue.Operator.StartEndEvery);
                }
                values.setEvery(this.expr());
            }
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            values.setSpaceName(this.expr());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.DATANODE)) {
            this.lexer.nextToken();
            values.setDataNodes(this.expr());
        }
        if (values != null) {
            values.setDistribute(isDistribute);
        }
        return values;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.COMPRESS_MODE)) {
            column.setCompression(this.expr());
            return this.parseColumnRest(column);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.COLLATE)) {
            column.setCollateExpr(this.expr());
            return this.parseColumnRest(column);
        }
        return super.parseColumnRest(column);
    }

    @Override
    protected SQLAggregateExpr parseAggregateExprRest(SQLAggregateExpr aggregateExpr) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.parseOrderBy();
            aggregateExpr.setOrderBy(orderBy);
            aggregateExpr.putAttribute("ORDER BY", orderBy);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SEPARATOR)) {
            this.lexer.nextToken();
            SQLExpr seperator = this.primary();
            seperator.setParent(aggregateExpr);
            aggregateExpr.putAttribute("SEPARATOR", seperator);
        }
        return aggregateExpr;
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
        if (this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.LITERAL_INT && this.lexer.token() != Token.VARIANT) {
            return new SQLIdentifierExpr("INTERVAL");
        }
        SQLCharExpr value = new SQLCharExpr(this.lexer.stringVal());
        this.lexer.nextToken();
        String literal = value.getText();
        String[] split = literal.split(" ");
        if (split.length == 2) {
            return new SQLIntervalExpr(new SQLIntegerExpr(Integer.parseInt(split[0])), SQLIntervalUnit.of(split[1]));
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DAY)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.DAY);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MONTH)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.MONTH);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.YEAR)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.YEAR);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.HOUR)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.HOUR);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MINUTE)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.MINUTE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.SECOND)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.SECOND);
        }
        intervalExpr.setValue(value);
        return intervalExpr;
    }

    @Override
    protected String nameCommon() {
        String identName = this.lexer.stringVal();
        this.lexer.nextToken();
        return identName;
    }

    static {
        String[] strings = new String[]{"SUM", "MAX", "MIN", "AVG", "MEDIAN", "PERCENTILE_CONT", "PERCENTILE_DISC", "COUNT", "ARRAY_AGG", "STRING_AGG", "LIST_AGG", "GROUP_CONCAT", "COVAR_POP", "COVAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "VAR_POP", "VAR_SAMP", "BIT_AND", "BIT_OR", "BOOL_AND", "BOOL_OR", "CORR", "EVERY", "RANK", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "STDDEV", "VARIANCE", "CHECKSUM"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            GaussDbExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

