/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.parser;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateSchemaStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DropSchemaStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2ValuesStatement;
import com.alibaba.druid.sql.dialect.db2.parser.DB2CreateTableParser;
import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.dialect.db2.parser.DB2SelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class DB2StatementParser
extends SQLStatementParser {
    public DB2StatementParser(String sql) {
        super(new DB2ExprParser(sql));
    }

    public DB2StatementParser(String sql, SQLParserFeature ... features) {
        super(new DB2ExprParser(sql, features));
    }

    public DB2StatementParser(Lexer lexer) {
        super(new DB2ExprParser(lexer));
    }

    @Override
    public DB2SelectParser createSQLSelectParser() {
        return new DB2SelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            DB2ValuesStatement stmt = new DB2ValuesStatement();
            stmt.setExpr(this.exprParser.expr());
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    @Override
    public SQLStatement parseCreateSchema() {
        this.accept(Token.CREATE);
        this.accept(Token.SCHEMA);
        DB2CreateSchemaStatement stmt = new DB2CreateSchemaStatement();
        stmt.setSchemaName(this.exprParser.name());
        while (this.lexer.token() != Token.SEMI && !this.lexer.isEOF()) {
            if (this.lexer.token() == Token.CREATE) {
                Lexer.SavePoint mark = this.lexer.markOut();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateTable());
                    continue;
                }
                if (this.lexer.token() == Token.VIEW) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateView());
                    continue;
                }
                if (this.lexer.token() == Token.INDEX) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateIndex());
                    continue;
                }
                if (this.lexer.token() == Token.SEQUENCE) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateSequence());
                    continue;
                }
                if (this.lexer.token() == Token.TRIGGER) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateTrigger());
                    continue;
                }
            }
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        return stmt;
    }

    @Override
    protected SQLDropStatement parseDropSchema(boolean physical) {
        DB2DropSchemaStatement stmt = new DB2DropSchemaStatement();
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setSchemaName(name);
        if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else {
            stmt.setCascade(false);
        }
        if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        }
        return stmt;
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new DB2CreateTableParser(this.exprParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SQLAlterTableAlterColumn parseAlterColumn() {
        if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
        }
        SQLColumnDefinition column = this.exprParser.parseColumn();
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        if (column.getDataType() != null || !column.getConstraints().isEmpty()) return alterColumn;
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.accept(Token.NULL);
                alterColumn.setSetNotNull(true);
                return alterColumn;
            } else if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                SQLExpr defaultValue = this.exprParser.expr();
                alterColumn.setSetDefault(defaultValue);
                return alterColumn;
            } else {
                if (!this.lexer.identifierEquals(FnvHash.Constants.DATA)) throw new ParserException("TODO : " + this.lexer.info());
                this.lexer.nextToken();
                this.acceptIdentifier("TYPE");
                SQLDataType dataType = this.exprParser.parseDataType();
                alterColumn.setDataType(dataType);
            }
            return alterColumn;
        } else {
            if (this.lexer.token() != Token.DROP) return alterColumn;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.accept(Token.NULL);
                alterColumn.setDropNotNull(true);
                return alterColumn;
            } else {
                this.accept(Token.DEFAULT);
                alterColumn.setDropDefault(true);
            }
        }
        return alterColumn;
    }

    @Override
    public SQLDeleteStatement parseDeleteStatement() {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement(this.getDbType());
        if (this.lexer.token() == Token.DELETE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            deleteStatement.setTableName(tableName);
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setFrom(tableSource);
            }
            deleteStatement.setAlias(this.tableAlias());
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    @Override
    public SQLStatement parseTruncate() {
        this.accept(Token.TRUNCATE);
        if (!this.lexer.nextIf(Token.TABLE)) {
            this.lexer.nextIfIdentifier("TABLE");
        }
        SQLTruncateStatement stmt = new SQLTruncateStatement(this.getDbType());
        SQLName name = this.exprParser.name();
        stmt.addTableSource(name);
        while (true) {
            if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setDropStorage(true);
                continue;
            }
            if (this.lexer.identifierEquals("REUSE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setReuseStorage(true);
                continue;
            }
            if (this.lexer.identifierEquals("IGNORE")) {
                this.lexer.nextToken();
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setIgnoreDeleteTriggers(true);
                continue;
            }
            if (this.lexer.token() == Token.RESTRICT) {
                this.lexer.nextToken();
                this.accept(Token.WHEN);
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setRestrictWhenDeleteTriggers(true);
                continue;
            }
            if (this.lexer.token() == Token.CONTINUE) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                continue;
            }
            if (this.lexer.token() == Token.RESTART) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                stmt.setRestartIdentity(Boolean.TRUE);
                continue;
            }
            if (!this.lexer.identifierEquals("IMMEDIATE")) break;
            this.lexer.nextToken();
            stmt.setImmediate(true);
        }
        return stmt;
    }
}

