/*
 * Copyright 1999-2017 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.druid.sql.dialect.postgresql.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lizongbo
 * @see <a href="https://www.postgresql.org/docs/current/sql-vacuum.html">VACUUM — garbage-collect and optionally analyze a database</a>
 */
public class PGVacuumStatement extends SQLStatementImpl implements PGSQLStatement {
    private boolean full;
    private boolean freeze;
    private boolean verbose;
    private boolean skipLocked;
    private boolean analyze;
    private boolean disablePageSkipping;
    private boolean processToast;
    private boolean truncate;
    // gaussDb specific
    private boolean deltaMerge;
    private boolean hdfsDirectory;
    private List<SQLExprTableSource> tableSources = new ArrayList<>();

    public PGVacuumStatement(DbType dbType) {
        super.dbType = dbType;
    }

    public boolean isVerbose() {
        return verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSkipLocked() {
        return skipLocked;
    }

    public void setSkipLocked(boolean skipLocked) {
        this.skipLocked = skipLocked;
    }

    public List<SQLExprTableSource> getTableSources() {
        return tableSources;
    }

    public void setTableSources(List<SQLExprTableSource> tableSources) {
        this.tableSources = tableSources;
    }

    public boolean isFull() {
        return full;
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public boolean isFreeze() {
        return freeze;
    }

    public void setFreeze(boolean freeze) {
        this.freeze = freeze;
    }

    public boolean isAnalyze() {
        return analyze;
    }

    public void setAnalyze(boolean analyze) {
        this.analyze = analyze;
    }

    public boolean isDisablePageSkipping() {
        return disablePageSkipping;
    }

    public void setDisablePageSkipping(boolean disablePageSkipping) {
        this.disablePageSkipping = disablePageSkipping;
    }

    public boolean isProcessToast() {
        return processToast;
    }

    public void setProcessToast(boolean processToast) {
        this.processToast = processToast;
    }

    public boolean isTruncate() {
        return truncate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof PGASTVisitor) {
            accept0((PGASTVisitor) visitor);
        }
    }

    @Override
    public void accept0(PGASTVisitor visitor) {
        if (visitor.visit(this)) {
            acceptChild(visitor, tableSources);
        }
        visitor.endVisit(this);
    }

    public boolean isDeltaMerge() {
        return deltaMerge;
    }

    public void setDeltaMerge(boolean deltaMerge) {
        this.deltaMerge = deltaMerge;
    }

    public boolean isHdfsDirectory() {
        return hdfsDirectory;
    }

    public void setHdfsDirectory(boolean hdfsDirectory) {
        this.hdfsDirectory = hdfsDirectory;
    }
}
